<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$success_message = null;
if (isset($_SESSION['success_message'])) {
    $success_message = $_SESSION['success_message'];
    unset($_SESSION['success_message']);
}

require_once 'config.php';
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

try {
    // گرفتن همه تیکت‌های پاسخ‌داده‌نشده
    $stmt = $db->query("SELECT * FROM support_tickets WHERE is_answered = 0 ORDER BY created_at ASC");
    $tickets = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error = "❌ خطا در ارتباط با دیتابیس: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تیکت‌های پشتیبانی</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Vazirmatn', sans-serif;
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;700&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-100 min-h-screen p-4">
    <div class="max-w-4xl mx-auto">
        <h2 class="text-2xl font-bold text-center text-gray-800 mb-6">📩 لیست تیکت‌های پاسخ‌داده‌نشده</h2>

        <?php if (isset($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg mb-6 animate-fade-in">
                <?= htmlspecialchars($error) ?>
            </div>
        <?php elseif (empty($tickets)): ?>
            <div class="bg-blue-100 border border-blue-400 text-blue-700 px-4 py-3 rounded-lg mb-6 text-center">
                هیچ پیام پشتیبانی باز وجود ندارد.
            </div>
            <?php if (isset($success_message)): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-6 animate-fade-in">
                    <?= htmlspecialchars($success_message) ?>
                </div>
        <?php endif; ?>
    <?php endif; ?> <!-- ✅ این خط اضافه شده برای بستن elseif اصلی -->
        <div class="space-y-6">
            <?php foreach ($tickets as $ticket): ?>
                <div class="bg-white rounded-lg shadow-md p-6 transition duration-200 hover:shadow-lg">
                    <div class="space-y-4">
                        <div class="flex items-center space-x-2">
                            <span class="text-lg">🆔</span>
                            <p class="text-gray-700"><strong>کاربر:</strong> <?= htmlspecialchars($ticket['user_id']) ?></p>
                        </div>
                        <div class="flex items-center space-x-2">
                            <span class="text-lg">🕐</span>
                            <p class="text-gray-700"><strong>زمان:</strong> <?= htmlspecialchars($ticket['created_at']) ?></p>
                        </div>
                        <div class="flex items-start space-x-2">
                            <span class="text-lg">📩</span>
                            <p class="text-gray-700"><strong>پیام:</strong> <?= nl2br(htmlspecialchars($ticket['message'])) ?></p>
                        </div>
                    </div>

                    <form action="reply_ticket.php" method="post" class="mt-4 space-y-4">
                        <input type="hidden" name="ticket_id" value="<?= htmlspecialchars($ticket['id']) ?>">
                        <input type="hidden" name="user_id" value="<?= htmlspecialchars($ticket['user_id']) ?>">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">✏️ پاسخ</label>
                            <textarea name="answer" required
                                      class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200"
                                      placeholder="پاسخ خود را وارد کنید" rows="4"></textarea>
                        </div>
                        <button type="submit"
                                class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition duration-200 font-medium">
                            ارسال پاسخ
                        </button>
                    </form>
                </div>
            <?php endforeach; ?>
        </div>

        <div class="mt-8 text-center">
            <a href="dashboard.php" class="text-blue-600 hover:text-blue-800 font-medium">⬅️ بازگشت به داشبورد</a>
        </div>
    </div>

    <script>
        // Simple animation for form inputs and cards
        textareas.forEach(textarea => {
            textarea.addEventListener('focus', () => {
                textarea.parentElement.classList.add('scale-105');
            });
            textarea.addEventListener('blur', () => {
                textarea.parentElement.classList.remove('scale-105');
            });
        });

        const cards = document.querySelectorAll('.bg-white');
        cards.forEach(card => {
            card.addEventListener('mouseenter', () => {
                card.classList.add('scale-105', 'shadow-lg');
            });
            card.addEventListener('mouseleave', () => {
                card.classList.remove('scale-105', 'shadow-lg');
            });
        });
    </script>
</body>
</html>