<?php
declare(strict_types=1);
ini_set('display_errors','1');
ini_set('display_startup_errors','1');
error_reporting(E_ALL);

date_default_timezone_set('Europe/Vienna');

// ===== تنظیمات خودت =====
$BOT_TOKEN = '7966366083:AAHBjvp9_2M6lrtrzdSmPrXIdvwRH6mmxxM'; // << توکن درستِ همین بات
$CHANNEL   = '@GoalTiime'; // << دقیقا همینی که تو تست موفق داشتی (کیس‌سنسیتیو بودن مهم نیست اما غلط‌ املایی خیلی رایجه)

// ===== کمک‌کننده‌ها =====
function out($label, $value) {
    echo "<pre><b>$label:</b> " . htmlspecialchars((string)$value, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') . "</pre>";
    @error_log("$label: $value");
}

// ===== 1) بررسی DNS =====
$dns = @dns_get_record('api.telegram.org', DNS_A);
$ips = [];
if ($dns && is_array($dns)) {
    foreach ($dns as $r) {
        if (!empty($r['ip'])) $ips[] = $r['ip'];
    }
}
out('DNS A records for api.telegram.org', json_encode($ips));
if (empty($ips)) {
    out('RESULT', '❌ DNS resolution failed. مشکل از DNS است (هاست یا فایروال).');
    exit;
}

// ===== 2) بررسی اتصال TCP پورت 443 =====
$tcp_ok = false;
$tcp_error = '';
foreach ($ips as $ip) {
    $errno = 0; $errstr = '';
    $fp = @fsockopen($ip, 443, $errno, $errstr, 5.0);
    if ($fp) {
        fclose($fp);
        $tcp_ok = true;
        out('TCP 443 connect', "✅ Connected to $ip:443");
        break;
    } else {
        $tcp_error .= "IP $ip failed: [$errno] $errstr | ";
    }
}
if (!$tcp_ok) {
    out('TCP 443 connect', "❌ Failed. $tcp_error");
    out('RESULT', '❌ خروجی پورت 443 بسته است (فایروال/هاست).');
    exit;
}

// ===== 3) نسخه cURL و OpenSSL =====
out('cURL version', function_exists('curl_version') ? json_encode(curl_version()) : 'curl not available');
out('OpenSSL version', defined('OPENSSL_VERSION_TEXT') ? OPENSSL_VERSION_TEXT : 'unknown');

// ===== 4) تست توکن: getMe =====
$me_url = "https://api.telegram.org/bot{$BOT_TOKEN}/getMe";
$me = @file_get_contents($me_url);
out('GET getMe (file_get_contents)', $me !== false ? $me : 'FAILED');
if ($me === false) {
    // تست با cURL با گزارش خطا
    $ch = curl_init($me_url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_TIMEOUT => 10,
    ]);
    $me2 = curl_exec($ch);
    $err = curl_error($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);
    out('GET getMe (cURL body)', $me2 !== false ? $me2 : 'FAILED');
    out('GET getMe (cURL error)', $err);
    out('GET getMe (cURL info)', json_encode($info));
    if ($me2 === false) {
        out('RESULT', '❌ ارتباط TLS/cURL مشکل دارد (گواهی/CA/نسخه TLS).');
        exit;
    } else {
        $me = $me2;
    }
}
$me_dec = json_decode((string)$me, true);
if (!$me_dec || empty($me_dec['ok'])) {
    out('RESULT', '❌ توکن نامعتبر یا پاسخ غیرمنتظره از Telegram.');
    exit;
}
out('Bot username', $me_dec['result']['username'] ?? '(unknown)');

// ===== 5) تست دسترسی کانال: getChat =====
$chat_url = "https://api.telegram.org/bot{$BOT_TOKEN}/getChat?chat_id=" . urlencode($CHANNEL);
$chat = @file_get_contents($chat_url);
out('GET getChat', $chat !== false ? $chat : 'FAILED');
$chat_dec = json_decode((string)$chat, true);
if (!$chat_dec || empty($chat_dec['ok'])) {
    out('RESULT', '❌ کانال یافت نشد یا دسترسی بات به کانال مشکل دارد (ممکنه از ادمینی خارج شده باشد).');
    exit;
}

// ===== 6) تست ارسال پیام ساده =====
$msg_url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
$post = [
    'chat_id' => $CHANNEL,
    'text'    => "✅ Connectivity test at " . date('Y-m-d H:i:s'),
    'disable_web_page_preview' => true
];
$ch = curl_init($msg_url);
curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $post,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_SSL_VERIFYPEER => true,
    CURLOPT_TIMEOUT => 10,
]);
$send = curl_exec($ch);
$cerr = curl_error($ch);
$cinfo = curl_getinfo($ch);
curl_close($ch);
out('sendMessage (cURL body)', $send !== false ? $send : 'FAILED');
out('sendMessage (cURL error)', $cerr);
out('sendMessage (cURL info)', json_encode($cinfo));
$send_dec = json_decode((string)$send, true);
if (!$send_dec || empty($send_dec['ok'])) {
    out('RESULT', '❌ درخواست به Telegram رفت ولی پاسخ ok:false بود (احتمالاً دسترسی بات به کانال/یوزرنیم/ریست توکن).');
    exit;
}

// ===== 7) تست IPv4 اجباری (اگر گاهی IPv6 مشکل‌ساز است) =====
$ip = gethostbyname('api.telegram.org'); // معمولاً A/IPv4
$hostHeader = 'api.telegram.org';
$ipv4_url = "https://$ip/bot{$BOT_TOKEN}/getMe";
$ch = curl_init($ipv4_url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ["Host: $hostHeader"],
    CURLOPT_SSL_VERIFYPEER => true,
    CURLOPT_TIMEOUT => 10,
]);
$ipv4 = curl_exec($ch);
$ipv4_err = curl_error($ch);
$ipv4_info = curl_getinfo($ch);
curl_close($ch);
out('IPv4 forced getMe body', $ipv4 !== false ? $ipv4 : 'FAILED');
out('IPv4 forced getMe error', $ipv4_err);
out('IPv4 forced getMe info', json_encode($ipv4_info));

// ===== نتیجه نهایی =====
out('RESULT', '✅ همه لایه‌های ارتباطی برقرار است. اگر final_whistle هنوز چیزی نفرستاد، یعنی شرط‌های منطقیِ آن فایل جلوی ارسال را گرفته (مثلاً داده جدیدی برای اعلان نبوده).');
