<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'config.php';
require_once 'functions.php';
require_once __DIR__ . '/../../../LiveScore/persiantranslate.php';

// اگر کانال را جای دیگری تعریف نکردی:
if (!defined('CHANNEL')) define('CHANNEL', '@kholasebegir');
if (!defined('TOKEN'))   define('TOKEN',   '7966366083:AAHBjvp9_2M6lrtrzdSmPrXIdvwRH6mmxxM');
$leagues = [
  '65' => 'پریمیرلیگ (انگلستان)',
  '75' => 'لالیگا (اسپانیا)',
  '77' => 'سری آ (ایتالیا)',
  '67' => 'بوندسلیگا (آلمان)',
  '68' => 'لیگ یک (فرانسه)',
  '403'=> 'لیگ حرفه‌ای عربستان',
  '145'=> 'ام‌ال‌اس (آمریکا)',
  'stage:iran/pro-league/2' => 'پرشین گلف (ایران)',
  '64' => 'اردیویزه (هلند)',
  '79' => 'پریمیرا لیگا (پرتغال)',
  '692' => 'لیگ نخبگان آسیا',
  '60' => 'لیگ قهرمانان اروپا: گروهی',
];

// از GET و POST هر دو بگیر
$sel = $_POST['competition'] ?? $_GET['competition'] ?? '65';
if (!array_key_exists($sel, $leagues)) $sel = '65';

// فقط داده‌ها را از لایواسکور بگیر
function getStatData($sel, $type) {
    if (strpos($sel, 'stage:') === 0) {
        $stagePath = substr($sel, 6);
        $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/stage/soccer/{$stagePath}/stat/?limit=50&locale=en";
    } else {
        $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/competition/{$sel}/stat/?limit=50&locale=en";
    }
    $json = @file_get_contents($url);
    $data = $json ? json_decode($json, true) : [];
    $players = [];
    if (!empty($data['Stat'])) {
        foreach ($data['Stat'] as $stat) {
            if ($type === 'goals'   && (int)$stat['Typ'] === 1) $players = $stat['Plrs'] ?? [];
            if ($type === 'assists' && (int)$stat['Typ'] === 3) $players = $stat['Plrs'] ?? [];
        }
    }
    return array_slice($players, 0, 5);
}

$topScorers = getStatData($sel, 'goals');
$topAssists = getStatData($sel, 'assists');

function getTopPlayersCaption($sel) {
    $scorers = getStatData($sel, 'goals');
    $assists = getStatData($sel, 'assists');

    if (!$scorers && !$assists) return '';

    global $leagues;
    $compTitle = getleagues($leagues[$sel] ?? 'لیگ');

    $lines = [];
    $lines[] = "🏆 برترین‌های {$compTitle}\n";
    if (!empty($scorers)) {
        $lines[] = "⚽️ گلزنان برتر:";
        foreach ($scorers as $i => $p) {
            $rank = convertToPersianNumbers($i + 1);
            $name = $p['Pnm'] ?? '-';
            $team = getTeamName($p['Tnm'] ?? '-');
            $val  = convertToPersianNumbers((int)($p['Scrs']['1'] ?? 0));
            $lines[] = "{$rank}. {$name} ({$team}) – {$val} گل";
        }
        $lines[] = "";
    }
    if (!empty($assists)) {
        $lines[] = "🎯 پاسورهای برتر:";
        foreach ($assists as $i => $p) {
            $rank = convertToPersianNumbers($i + 1);
            $name = $p['Pnm'] ?? '-';
            $team = getTeamName($p['Tnm'] ?? '-');
            $val  = convertToPersianNumbers((int)($p['Scrs']['3'] ?? 0));
            $lines[] = "{$rank}. {$name} ({$team}) – {$val} پاس گل";
        }
    }

    // $lines[] = "\n📲 برای آمار کامل:\n@Playerscubebot";

    return implode("\n", $lines);
}

// اگر دکمه ارسال زده شد
// if (isset($_POST['send'])) {
//     $scorers = getStatData($sel, 'goals');
//     $assists = getStatData($sel, 'assists');

//     if (!$scorers && !$assists) {
//         echo "<div style='color:#f66;margin-top:12px'>❌ اطلاعات بازیکنان در دسترس نیست.</div>";
//     } else {
//         // عنوان لیگ را با تابع خودت نگاشت کن
//         $compTitle = getleagues($leagues[$sel] ?? 'لیگ');

//         $lines = [];
//         $lines[] = "⚽️ گلزنان برتر:";
//         foreach ($scorers as $i => $p) {
//             $rank = convertToPersianNumbers($i + 1);
//             $name = $p['Pnm'] ?? '-';
//             $team = getTeamName($p['Tnm'] ?? '-');
//             $val  = convertToPersianNumbers((int)($p['Scrs']['1'] ?? 0));
//             $lines[] = "{$rank}. {$name} ({$team}) – {$val} گل";
//         }

//         $lines[] = "\n🎯 پاسورهای برتر:";
//         foreach ($assists as $i => $p) {
//             $rank = convertToPersianNumbers($i + 1);
//             $name = $p['Pnm'] ?? '-';
//             $team = getTeamName($p['Tnm'] ?? '-');
//             $val  = convertToPersianNumbers((int)($p['Scrs']['3'] ?? 0));
//             $lines[] = "{$rank}. {$name} ({$team}) – {$val} پاس گل";
//         }

//         // CTA پایین پیام
//         $lines[] = "\n📲 برای آمار کامل:\n@Playerscubebot";

//         $caption = "🏆 برترین‌های {$compTitle}\n\n" . implode("\n", $lines);

//         // $ok = tg_sendMessage(CHANNEL, $caption);
//         // echo $ok
//         //   ? "<div style='color:#7CFC7C;margin-top:12px'>✅ پیام با موفقیت به کانال ارسال شد.</div>"
//         //   : "<div style='color:#f66;margin-top:12px'>❌ خطا در ارسال پیام (توکن/دسترسی کانال را بررسی کنید).</div>";
//     }
// }
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>ارسال برترین‌ها</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { background:#0b0f16; color:#fff; font-family:sans-serif; padding:20px; }
    h2 { margin-bottom:10px; }
    ul { padding:0; list-style:none; }
    li { background:#1c1f26; padding:8px 12px; margin:4px 0; border-radius:6px; }
    .tag { font-size:13px; color:#aaa; }
    .btn { padding:10px 18px; background:#4CAF50; border:none; color:#fff; border-radius:6px; font-weight:bold; cursor:pointer; margin-top:20px; }
    select { padding:6px 10px; border-radius:6px; }
  </style>
</head>
<body>

  <!--<h2>📊 برترین گلزنان و پاسورها</h2>-->

  <!--<form method="get">-->
  <!--  <label>انتخاب لیگ:</label>-->
  <!--  <select name="competition" onchange="this.form.submit()">-->
  <!--    <?php foreach ($leagues as $id => $name): ?>-->
  <!--      <option value="<?= htmlspecialchars($id) ?>" <?= $id === $sel ? 'selected' : '' ?>>-->
  <!--        <?= getleagues($name) ?>-->
  <!--      </option>-->
  <!--    <?php endforeach; ?>-->
  <!--  </select>-->
  <!--</form>-->

  <h3>⚽ برترین گلزنان:</h3>
  <ul>
    <?php foreach ($topScorers as $p): ?>
      <li>
        <?= htmlspecialchars($p['Pnm'] ?? '-') ?>
        <span class="tag"> - <?= getTeamName($p['Tnm'] ?? '-') ?> (<?= (int)($p['Scrs']['1'] ?? 0) ?>)</span>
      </li>
    <?php endforeach; ?>
  </ul>

  <h3>🎯 برترین پاسورها:</h3>
  <ul>
    <?php foreach ($topAssists as $p): ?>
      <li>
        <?= htmlspecialchars($p['Pnm'] ?? '-') ?>
        <span class="tag"> - <?= getTeamName($p['Tnm'] ?? '-') ?> (<?= (int)($p['Scrs']['3'] ?? 0) ?>)</span>
      </li>
    <?php endforeach; ?>
  </ul>

  <!--<form method="post">-->
  <!--  <input type="hidden" name="send" value="1">-->
  <!--  <input type="hidden" name="competition" value="<?= htmlspecialchars($sel) ?>">-->
  <!--  <button type="submit" class="btn">🚀 ارسال به کانال</button>-->
  <!--</form>-->

</body>
</html>
