<?php

date_default_timezone_set('Asia/Tehran');

require_once(__DIR__ . '/txt.php');
require_once(__DIR__ . '/data.php');
require_once(__DIR__ . '/libs/MrMDPDO.php');
require_once(__DIR__ . '/libs/LiveScore.php');

$liveScore = new LiveScore();

$Obj = new Database(
    [
        'username' => "$Db_Username",
        'password' => "$Db_Password",
        'dbname' => "$Db_Name",
    ]

);
 

function bot(string $method, array $data = []): array
{
    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL            => 'https://api.telegram.org/bot' . TOKEN . '/' . $method,
        CURLOPT_POSTFIELDS     => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER     => ['Content-Type: application/x-www-form-urlencoded'],
        CURLOPT_TIMEOUT        => 10, 
    ]);

    $result = curl_exec($curl);

    if (curl_errno($curl)) {
        error_log('cURL Error: ' . curl_error($curl));
        curl_close($curl);
        return ['ok' => false, 'error' => curl_error($curl)];
    }

    curl_close($curl);

    $response = json_decode($result, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log('JSON Decode Error: ' . json_last_error_msg());
        return ['ok' => false, 'error' => 'Invalid JSON response'];
    }

    return $response;
}


function translate($from, $to, $text1) {
    $fields = array(
        'sl' => urlencode($from),
        'tl' => urlencode($to),
        'q' => urlencode($text1)
    ); 
    $fields_string = http_build_query($fields); // استفاده از http_build_query

    $ch = curl_init(); 
    curl_setopt_array($ch, [ 
        CURLOPT_URL => 'https://translate.googleapis.com/translate_a/single?client=gtx&dt=t', 
        CURLOPT_POSTFIELDS => $fields_string, 
        CURLOPT_RETURNTRANSFER => true, 
        CURLOPT_ENCODING => 'UTF-8', 
        CURLOPT_SSL_VERIFYPEER => false, 
        CURLOPT_SSL_VERIFYHOST => false, 
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36(KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36', 
    ]); 

    $result = json_decode(curl_exec($ch), true); 
    curl_close($ch); // بستن Curl

    if (!$result || !isset($result[0])) {
        return "خطا در ترجمه."; // مدیریت خطا
    }

    $m = ''; // مقداردهی اولیه متغیر $m
    foreach ($result[0] as $Z) { 
        $m .= $Z[0];
    }
    return $m; 
}

function openLink(
    string $url,
    
    string $method = 'GET',
    array $params = [],
    array $headers = [],
    bool $decode = false,
    int $timeout = 15){
    if ($method == 'GET' and count($params) > 0)
    {
        $url = $url . '?' . http_build_query($params);
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    if ($method == 'POST')
    {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    }
    if (count($headers) > 0)
    {
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    }
    $response = curl_exec($ch);
    if ($decode == true)
    {
        $response = json_decode($response, true);
    }
    curl_close($ch);
    return $response;
}

function sendMessage($chatId, $text, $reply_markup = null){
    return bot('sendMessage', [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'disable_web_page_preview' => true,
        'reply_markup' => $reply_markup
    ]);
}

function forwardMessage($chatId, $from_chat_id, $message_id){
    return bot('forwardMessage', [
        'chat_id' => $chatId,
        'from_chat_id' => $from_chat_id,
        'message_id' => $message_id,
    ]);
}

function editMessageText($chatId, $message_id, $text, $reply_markup = null){
    return bot('editMessageText', [
        'chat_id' => $chatId,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'reply_markup' => $reply_markup
    ]);
}

function sendMediaGroup($chatId,$media){
    return bot('sendMediaGroup',[
        'chat_id' => $chatId,
        'media' => json_encode($media),
    	'parse_mode'=>'Markdown',
        'disable_web_page_preview'=>true
    ]);

}

function InlineQuery($id,$from,$query,$offset){
    return bot('InlineQuery',[
        'id'=>$id,
        'from'=>$from,
        'query' => $query,
        'offset' => $offset,
        // 'chat_type' => $chat_type
    ]); 
}

function answerInlineQuery($inline_query_id,$cache_time,$results){
    
    return bot('answerInlineQuery',[
        'inline_query_id'=>$inline_query_id,
        'results'=>json_encode($results),
        'cache_time' => $cache_time
    ]); 
}

function answerCallbackQuery($callbackId,$text){

    return bot('answerCallbackQuery',[
        'callback_query_id'=>$callbackId,
        'text'=>"$text",
        'show_alert' => false
    ]);
}

function resultsxForTable($titles) {

    $results = [];

    foreach ($titles as $title) {
        $CID = $title['CountryId']??"x";
        // $CompId = $title['CompId']??"x";
        $CNAME = $title['Country']??"x";
        $CLIG = $title['LigName']??"x";
        $CFlLAG = $title['CountryLink']??"x";
        $TableLig = $title['LigTable']??"x";

        $thumbnail_url = (strlen($CNAME) < 10) ? "https://static.livescore.com/i2/fh/" . strtolower($CNAME) . ".jpg" : "";
        // $thumbnail_url = "https://www.eligasht.com/Blog/wp-content/uploads/2018/06/4442.jpg";
        
        $results[] = [
            'id' => base64_encode(rand(0, 9999)),
            'title' => $CNAME,
            'type' => 'article',
            'description' => $CLIG,
            'thumbnail_url' => $thumbnail_url,
            'input_message_content' => [
                'message_text' => "GetTable|".strtolower($CNAME)."^^".strtolower($TableLig),
                'parse_mode' => 'MarkDown',
                'disable_web_page_preview' => true,
            ]
        ];
    }

    return $results;
}

function results($titles) {
    $results = [];
    foreach (array_slice($titles, 0, 50) as $title) {
        $results[] = buildResultItem($title);
    }
    return $results;
}

function delmessage($chatId,$message_id){
    return bot('deleteMessage',['chat_id'=>$chatId,'message_id'=>$message_id]); 
}

function advancedBuild($buttons,$ButtunsId, $perline = 1, $json = true, $prefix = "", $suffix = ""){
    $keyboard = array();
    $n = $m = 0;
    $Num = 0;
    foreach ($buttons as $button){
        if ((is_array($perline) && $perline[$m] == $n) || $n == $perline){
            $m++;
            $n = 0;
        }
        $keyboard[$m][] = ['text' => trim($prefix." ".$button." ".$suffix),'callback_data'=>$ButtunsId[$Num]];
        $n++;
        $Num++;
    }
    if ((is_array($perline) && $perline[$m] == $n) || $n == $perline){
        $m++;
        $n = 0;
    }

    $keyboard[$m][] = ['text' => trim($prefix."Main Menu".$suffix),'callback_data'=>"LiveScore"];

    return $json 
        ? json_encode([
            'inline_keyboard' => $keyboard,
            'resize_keyboard' => true
        ])
        : $keyboard;
}

function sendByUpdate($text, $chatId, $type, $messageId){
    
    global $BotUserName;
    global $ForUpdate;
    global $EmptyData;
    global $wait;
    global $liveScore;

    preg_match("/(\d{4})(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])\|(\w.*)-(\d.*)/i", $text, $m);

    $Year = $m[1];
    $Month = $m[2];
    $Day = $m[3];
    $Lig = $m[4];
    $LigId = $m[5];
    $Date = "{$Year}{$Month}{$Day}";
    $Lives = $liveScore->livescorebydate($Date);
    foreach ($Lives as $Live) {
        if ((int)$LigId == (int)$Live->Sid??'12') {

            $TXT = "";
            foreach ($Live->Events as $Event) {
                $GameMin = $Event->Eps ?? '?';
                $HomeTeam = $Event->T1[0]->Nm ?? '';
                $HomeTeamCountry = $Event->T1[0]->CoNm ?? '';
                $HomeGoals = $Event->Tr1 ?? '-';
                $GuestTeam = $Event->T2[0]->Nm ?? '';
                $GuestTeamCountry = $Event->T2[0]->CoNm ?? '';
                $GuestGoals = $Event->Tr2 ?? '-';

                if ($GameMin == "Postp.") {
                    $formatted_date = "Postponed";}
                elseif ($GameMin == "Canc.") {
                    $formatted_date = "Canceled";}
                elseif ($GameMin == "AP") {
                    $formatted_date = "After Penalties";}
                elseif ($GameMin == "AET") {
                    $formatted_date = "After Extra Time"; }
                elseif ($GameMin == "FT") {
                    $formatted_date = "Full Time";}
                elseif ($GameMin == "HT") {
                    $formatted_date = "Half Time";
                }
                elseif ($GameMin == "NS") {
                    $date_str = $Event->Esd ?? '?';
                    // if($Live->Csnm??'x' == "Iran"){
                        $H = substr("$date_str",-6,2);
                        $Min = substr("$date_str",-4,2);
                        $formatted_date = "NS $H:$Min";

                    // }else{
                        // $formatted_date = "NS ".Miladi_To_Shamsi($date_str,'HH:mm');
                    // }

                }

                
                $TXT .= "━━━━━━ ". ($formatted_date ?? $GameMin) ." ━━━━━━\n";
                $TXT .= "🔷 {$HomeTeam}\n";
                $TXT .= "⚽️ {$HomeGoals} : {$GuestGoals}\n";
                $TXT .= "🔶 {$GuestTeam}\n";
                $TXT .= "\n"; 
            }

	            $TXT .= "━━━━ $BotUserName ━━━━";
                $TXT .= "\n"; 
                $TXT .= "\n";

            if ($type == "send") {

                return bot('sendMessage', [
                    'chat_id' => $chatId,
                    'text' => "*{$TXT}*",
                    'parse_mode' => 'Markdown',
                    'disable_web_page_preview' => true,
                    'reply_markup' => json_encode([
                        'resize_keyboard' => true,
                        'inline_keyboard' => [
                            [['text' => '↻ Refresh', 'callback_data' => "$text"]],
                            [['text' => 'Main Menu', 'callback_data' => 'LiveScore']]

                            ],
                    ]),
                ]);
            } else {
                return editMessageText($chatId, $messageId, "*{$ForUpdate}\n\n{$TXT}*", json_encode([
                    'resize_keyboard' => true,
                        'inline_keyboard' => [
                                [['text' => '↻ Refresh', 'callback_data' => "$text"]],
                                [['text' => 'Main Menu', 'callback_data' => 'LiveScore']]
                            ],
                    ]));
            }
        }

    }

    return sendMessage($chatId, "*$EmptyData*");
}

function NewsInfo($teamid2, $inline_queryId) {
    global $liveScore, $Obj, $BotUserName;

    $url = "https://content.api.uk1.sportal365.com/articles/search/?query=*&page=1&status=active&optional_data=sports_related&category=2021020913320920836&teamIds=$teamid2";

    $body = fetchWithCacheNewsInfo($url, 600); // کش برای 10 دقیقه

    if ($body === false) {
        return false; 
    }

    $HH = json_decode($body, true);
    $results = [];
    $NUMBER = 0;

    if (isset($HH['data'])) {
        foreach ($HH['data'] as $data) {
            $NUMBER += 1;
            $title = $data['title'] ?? '-';
            $subtitle = $data['subtitle'] ?? '-';
            $bodys = $data['body'];
            $image = $data['image']['data']['urls']['uploaded']['embed'] ?? "-";
            $Text = ".";
            foreach ($bodys as $body) {
                $Text .= $body['data']['content'] ?? "";
            }

            if ($NUMBER > 10) { // شرط مشابه کد اصلی
                $results[] = [
                    'id' => base64_encode(rand(0, 9999)),
                    'title' => $title,
                    'type' => 'article',
                    'description' => $subtitle,
                    'thumbnail_url' => $image,
                    'input_message_content' => [
                        'message_text' => "*$title*\n$subtitle",
                        'parse_mode' => 'MarkDown'
                    ]
                ];
            }
        }
    } else {
        $results[] = [
            'id' => base64_encode(rand(0, 9999)),
            'title' => "Coming Soon",
            'type' => 'article',
            'description' => "به زودی",
            'input_message_content' => [
                'message_text' => "به زودی",
                'parse_mode' => 'MarkDown'
            ]
        ];
    }

    return answerInlineQuery($inline_queryId, 0, $results);
}

function fetchWithCacheNewsInfo($url, $cacheTime = 600) {
    $cacheDir = __DIR__ . '/cache/';
    $cacheFile = $cacheDir . md5($url) . '.cache';

    if (!is_dir($cacheDir)) {
        mkdir($cacheDir, 0777, true);
    }

    if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $cacheTime)) {
        return file_get_contents($cacheFile);
    }

    $headers = [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0',
        'Accept: */*',
        'Accept-Language: en-US,en;q=0.5',
        'Accept-Encoding: gzip, deflate, br, zstd',
        'Referer: https://www.livescore.com/',
        'Project: livescore.com',
        'Origin: https://www.livescore.com',
        'Sec-Fetch-Dest: empty',
        'Sec-Fetch-Mode: cors',
        'Sec-Fetch-Site: cross-site',
        'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJhdWQiOiIyIiwianRpIjoiYTVjYjZiMWUwZDE0Njk4MjEzNTYxMzA2MmJiZjZhZjNkYjAyYzY4Y2VhODZkNTQyZTkzNWRjM2U3NDY0YTk0MDkzYzYyNjdmOWM2MGM0ODEiLCJpYXQiOjE3Mjk2ODE2NjkuODUyMjA3LCJuYmYiOjE3Mjk2ODE2NjkuODUyMjA5LCJleHAiOjE3NjEyMTc2NjkuODM1ODE1LCJzdWIiOiIyMDIzMDMwMjE0NTQwODg2MDIyIiwic2NvcGVzIjpbXX0.Oyh58H3rsi64ZPAXGZuXwraBAmdra3bRGrpaININaGaw5ZBhJn1yrDb1_JJmKnV_Z40w2QLNKb9w_ZxpBEMVZTJbkbQp6JqlxVwP9omaDt3neRHc7CuGzL5Y4Zf368Ue49qDxDKHx2s6Klfk2ErcSVBBIhKx2vITXQqDypqNV2-C0bz2qULJnmY7SrGY-RuHXJlIBsPwRH2ZR60wqxCprqs4dgxGRU_NRZNsFhZKXu7Fy3FfKrf0tlZcVS0aVbI8rp8Si6chqPV6qDheyeDH-p3hj-ld4LZ5-MmZ5vRUZluOcHMsDPBxKkbeihidZKXUy7dYqQMq2LMqOKMzraKc4MtbINJp-86fqzZ0FgMYNLyzjRN5txyZ6n1tFE931vMVOGyDRuExyJ-aUZwmJkHvNwkhbP97bF3TnPCP3-fNZwyAfmdnoDM7DPO6lu7F7bwNO6qbLJNqpXVem28sODOnD2abuvkLMtal4NYCboDHgzvNKrVEISjx-MSdcH023D-iTeHAO5Lb1xJO7U_Z2zEefohjy1XLfQEFnj6itnU9racDpFgi-ThSxE8QWup9xU2eC9GmjDI5PSvtbEsNr4BYXqBvkxFjwcdrPijPNSjiY10TvZVVFp_eptgfeR_QrRddqa4uqMhC9EFUsAJnLNUXche0VFxe4UpatrfCyy9lDSk',
        'Connection: keep-alive',
        'Priority: u=4',
        'TE: trailers',
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_ENCODING, ''); 
    curl_setopt($ch, CURLOPT_HEADER, true); 
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);
        return false;
    }

    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $header = substr($response, 0, $header_size);
    $body = substr($response, $header_size);

    if (strpos($header, 'Content-Encoding: gzip') !== false) {
        $body = gzdecode($body);
    } elseif (strpos($header, 'Content-Encoding: deflate') !== false) {
        $body = gzinflate($body);
    } elseif (strpos($header, 'Content-Encoding: br') !== false) {
        if (function_exists('brotli_uncompress')) {
            $body = brotli_uncompress($body);
        } else {
            echo "brotli compression not supported.";
            curl_close($ch);
            return false;
        }
    }

    curl_close($ch);

    file_put_contents($cacheFile, $body);

    return $body;
}

function sendById($inlinedata,$chatId,$callbackId,$type,$messageId){
    global $ForUpdate;
    global $BotUserName;
    global $wait;
    global $Noting;
    $inlinedata = str_replace("id-","",$inlinedata);
    $explode= explode("-",$inlinedata);
    $date = $explode[0];
    $id = $explode[1];

    if($date == "Live"){
        $Link = "https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30";
        $PeerLine = 2;

    }else{
        $Link = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/$date/3.30?countryCode=FR&locale=en&MD=1";
    }
    $response = file_get_contents($Link);
    
    $Lives = json_decode($response)->Stages;
    if(count($Lives)<1){
        return bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=>"$Noting",
            'show_alert' => true
        ]); 
    }else{
        bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=>"$wait",
            'show_alert' => false
        ]); 
    }
    
    $TXT2 = '';

    foreach($Lives as $Live){
        $Id = $Live->Sid;
        $Name = $Live->Snm;
        $Continent = $Live->Cnm;
        $ContinentT = $Live->CnmT;
        if((string)$id === (string)$Id){
            $Events = $Live->Events;
            $TXT = "";
            $Buttun = [];
            $TXT .= "{$Continent} / {$Name}\n";
            $TXT .= "\n";
            
    foreach($Events as $Event){
                try{
                    $GameMin = $Event->Eps;
                    $Eid = $Event->Eid;
                    $HomeTeam = $Event->T1[0]->Nm??"";
                    $HomeTeamCountry = $Event->T1[0]->CoNm??$Continent;
                    $HomeGoals = $Event->Tr1??'-';
                    $GuestTeam = $Event->T2[0]->Nm;
                    $GuestTeamCountry = $Event->T2[0]->CoNm??$Continent;
                    $GuestGoals = $Event->Tr2??'-';
                    $HomeTeamLower = str_replace(' ','-',strtolower($HomeTeam)).'-vs-'.str_replace(' ','-',strtolower($GuestTeam));
                    $Linkcheck = json_decode(file_get_contents("https://www.livescore.com/_next/data/en/football/live.json?sport=football"),true);
                    $link = $Linkcheck['pageProps']['__N_REDIRECT'];
                    $parts = parse_url($link);
                    parse_str($parts['query'], $queryParams);
                    $buildid = $queryParams['buildid'];
                    $Linkcheck = "https://www.livescore.com/_next/data/$buildid/en/football/$ContinentT/eredivisie/$HomeTeamLower/$Eid.json?sport=football&eventId=$Eid";
                    $golaplayer = '';
                    $HomeGoalsPlayers = '';
                    $AwayGoalsPlayers = '';
                    $Linkcheck = json_decode(file_get_contents($Linkcheck),true);

                    if(isset($Linkcheck['pageProps']['initialEventData']['event']['incidents']['incs']['football1'])){
                        $HomeLinkcheck1 = $Linkcheck['pageProps']['initialEventData']['event']['incidents']['incs']['football1'];
                        foreach($HomeLinkcheck1 as $data){
                            if(isset($data[0]['AWAY']) && $data[0]['AWAY']>0){
                                if(isset($data[0]['AWAY'][0]['type']) && ($data[0]['AWAY'][0]['type'] == 'FootballGoal' or 
                                $data[0]['AWAY'][0]['type'] == 'FootballOwnGoal' or $data[0]['AWAY'][0]['type'] == 'FootballGoalPen'))
                                {
                                    $playergoalname = $data[0]['AWAY'][0]['shortName'];
                                    $playergoaltime = $data[0]['AWAY'][0]['time'];
                                    $AwayGoalsPlayers = $AwayGoalsPlayers."⚽️ $playergoalname $playergoaltime\n";
                                }
                            }
                            // FootballOwnGoal
                            if(isset($data[0]['HOME']) && $data[0]['HOME']>0){
                                if(isset($data[0]['HOME'][0]['type']) && ($data[0]['HOME'][0]['type'] == 'FootballOwnGoal' or 
                                $data[0]['HOME'][0]['type'] == 'FootballGoal' or $data[0]['HOME'][0]['type'] == 'FootballGoalPen'))
                                {
                                    $playergoalname = $data[0]['HOME'][0]['shortName'];
                                    $playergoaltime = $data[0]['HOME'][0]['time'];
                                    $HomeGoalsPlayers = $HomeGoalsPlayers."⚽️ $playergoalname $playergoaltime\n";
                                }
                            }
                            
                        }
                    }
                    
                    if(isset($Linkcheck['pageProps']['initialEventData']['event']['incidents']['incs']['football2'])){
                        $HomeLinkcheck1 = $Linkcheck['pageProps']['initialEventData']['event']['incidents']['incs']['football2'];
                        foreach($HomeLinkcheck1 as $data){
                            if(isset($data[0]['AWAY']) && $data[0]['AWAY']>0){
                                if(isset($data[0]['AWAY'][0]['type']) && ($data[0]['AWAY'][0]['type'] == 'FootballOwnGoal' or 
                                $data[0]['AWAY'][0]['type'] == 'FootballGoal' or $data[0]['AWAY'][0]['type'] == 'FootballGoalPen'))
                                {
                                    $playergoalname = $data[0]['AWAY'][0]['shortName'];
                                    $playergoaltime = $data[0]['AWAY'][0]['time'];
                                    $AwayGoalsPlayers = $AwayGoalsPlayers."⚽️ $playergoalname $playergoaltime\n";
                                }
                            }
                            if(isset($data[0]['HOME']) && $data[0]['HOME']>0){
                                if(isset($data[0]['HOME'][0]['type']) && ( $data[0]['HOME'][0]['type'] == 'FootballOwnGoal' or  
                                $data[0]['HOME'][0]['type'] == 'FootballGoal' or $data[0]['HOME'][0]['type'] == 'FootballGoalPen'))
                                {
                                    
                                    $playergoalname = $data[0]['HOME'][0]['shortName'];
                                    $playergoaltime = $data[0]['HOME'][0]['time'];
                                    $HomeGoalsPlayers = $HomeGoalsPlayers."⚽️ $playergoalname $playergoaltime\n";
                                }
                            }
                        }
                    }

                    if(isset($Linkcheck['pageProps']['initialEventData']['event']['incidents']['incs']['football3'])){
                        $HomeLinkcheck1 = $Linkcheck['pageProps']['initialEventData']['event']['incidents']['incs']['football3'];
                        foreach($HomeLinkcheck1 as $data){
                            if(isset($data[0]['AWAY']) && $data[0]['AWAY']>0){
                                if(isset($data[0]['AWAY'][0]['type']) && ($data[0]['AWAY'][0]['type'] == 'FootballOwnGoal' or 
                                $data[0]['AWAY'][0]['type'] == 'FootballGoal' or $data[0]['AWAY'][0]['type'] == 'FootballGoalPen'))
                                {
                                    $playergoalname = $data[0]['AWAY'][0]['shortName'];
                                    $playergoaltime = $data[0]['AWAY'][0]['time'];
                                    $AwayGoalsPlayers = $AwayGoalsPlayers."⚽️ $playergoalname $playergoaltime\n";
                                }
                            }
                            if(isset($data[0]['HOME']) && $data[0]['HOME']>0){
                                if(isset($data[0]['HOME'][0]['type']) && ( $data[0]['HOME'][0]['type'] == 'FootballOwnGoal' or  
                                $data[0]['HOME'][0]['type'] == 'FootballGoal' or $data[0]['HOME'][0]['type'] == 'FootballGoalPen'))
                                {
                                    
                                    $playergoalname = $data[0]['HOME'][0]['shortName'];
                                    $playergoaltime = $data[0]['HOME'][0]['time'];
                                    $HomeGoalsPlayers = $HomeGoalsPlayers."⚽️ $playergoalname $playergoaltime\n";
                                }
                            }
                            
                        }
                    }
                    
                    if(isset($Linkcheck['pageProps']['initialEventData']['event']['incidents']['incs']['football4'])){
                                $HomeLinkcheck1 = $Linkcheck['pageProps']['initialEventData']['event']['incidents']['incs']['football4'];
                                foreach($HomeLinkcheck1 as $data){
                                    if(isset($data[0]['AWAY']) && $data[0]['AWAY']>0){
                                        if(isset($data[0]['AWAY'][0]['type']) && ($data[0]['AWAY'][0]['type'] == 'FootballOwnGoal' or 
                                        $data[0]['AWAY'][0]['type'] == 'FootballGoal' or $data[0]['AWAY'][0]['type'] == 'FootballGoalPen'))
                                        {
                                            $playergoalname = $data[0]['AWAY'][0]['shortName'];
                                            $playergoaltime = $data[0]['AWAY'][0]['time'];
                                            $AwayGoalsPlayers = $AwayGoalsPlayers."⚽️ $playergoalname $playergoaltime\n";
                                        }
                                    }
                                    if(isset($data[0]['HOME']) && $data[0]['HOME']>0){
                                        if(isset($data[0]['HOME'][0]['type']) && ( $data[0]['HOME'][0]['type'] == 'FootballOwnGoal' or  
                                        $data[0]['HOME'][0]['type'] == 'FootballGoal' or $data[0]['HOME'][0]['type'] == 'FootballGoalPen'))
                                        {
                                            
                                            $playergoalname = $data[0]['HOME'][0]['shortName'];
                                            $playergoaltime = $data[0]['HOME'][0]['time'];
                                            $HomeGoalsPlayers = $HomeGoalsPlayers."⚽️ $playergoalname $playergoaltime\n";
                                        }
                                    }
                                    
                                }
                            }

                    if($GameMin == "NS" or $GameMin == "FT" or $GameMin == "Postp."){
                        $date_str = $Event->Esd;
                        $formatted_date = Miladi_To_Shamsi2(3,$date_str,'yyyy/MM/dd - HH:mm');

                    if($GameMin == "Postp."){
                        $formatted_date = "Postponed";
                    }elseif($GameMin == "Canc."){
                        $formatted_date = "Canceled";
                    }
                    elseif($GameMin == "AP"){
                        $formatted_date = "After Penalties";
                    }
                    elseif($GameMin == "AET"){
                        $formatted_date = "After Extra Time";
                    }elseif($GameMin == "FT"){
                        $formatted_date = "Full Time";
                    }elseif($GameMin == "HT"){
                        $formatted_date = "Half Time";
                    }

$TXT .= "━━━━━━ $formatted_date ━━━━━━\n";
$TXT .= "🔷 $HomeTeam\n";
if($HomeGoalsPlayers !== ''){
    $TXT .= "$HomeGoalsPlayers\n";
}
$TXT .= "🔍️ {$HomeGoals} : {$GuestGoals}\n\n";
$TXT .= "🔶 $GuestTeam\n";
$TXT .= "$AwayGoalsPlayers\n";

                    }else{
$TXT .= "━━━━━━ $GameMin ━━━━━━\n";
$TXT .= "🔷 {$HomeTeam}\n";
if($HomeGoalsPlayers !== ''){
    $TXT .= "$HomeGoalsPlayers\n";
}$TXT .= "🔍 {$HomeGoals} : {$GuestGoals}\n\n";
$TXT .= "🔶 {$GuestTeam}\n";
$TXT .= "$AwayGoalsPlayers\n";
$TXT .= "\n";
                }
                }catch (\Throwable $e){
            }
                
        }
        
// $TXT .= "$TXT2\n";
$TXT .= "━━━━ @GoalTiime ━━━━";
            // $TXT .= "🔴 پخش زنده بازی پرسپولیس 17:15 استقلال: https://telewebion.com/live/tv3";
$TXT .= "\n"; 
$TXT .= "\n";

                $MKeyboard = [
                    [['text' => '↻ Refresh', 'callback_data' => "|-id-$inlinedata"]],
                    [['text' => 'Main Menu', 'callback_data' => 'LiveScore']]

                ];
                $MainKeyboard= json_encode([
                    'resize_keyboard'=>true,
                    'inline_keyboard'=>$MKeyboard
                ]);
                if($type == "send"){
                    return	bot('sendMessage',[
                	'chat_id'=>$chatId,
                	'text'=>"$TXT",
                	'parse_mode'=>'Markdown',
                	'disable_web_page_preview'=>true,
                	'reply_markup'=>$MainKeyboard,
                	'reply_to_message_id'=>$messageId

                	]);
                }else{
                    $TXT = "$ForUpdate\n\n$TXT";
                    return editMessageText($chatId,$messageId,"*$TXT*",$MainKeyboard);
                }
                
                
                
        }
    }

}

function Check($chatId,$callbackId=0){
    global $Obj;
    global $waitTime;
    $data = "UserId=$chatId";
    if($Obj->has('Users', $data)){
        // $LastTime = $Obj->select("Users","UserId=$chatId","`Limit`")[0]['Limit'];
        $LastTime = $Obj->select('Users', '`Limit`', ['UserId' => $chatId])[0]['Limit'];

        if((time()-(int)$LastTime <1)){
            if($callbackId !== 0){
                bot('answerCallbackQuery',[
                    'callback_query_id'=>$callbackId,
                    'text'=>"$waitTime",
                    'show_alert' => true
                ]);
            }else{
                 bot('sendMessage',[
                    'chat_id'=>$chatId,
                    'text'=>$waitTime,
                    'parse_mode' => 'Markdown'
                ]); 
            }
            return die();
        }
        $data = [
        '`Limit`' => time(),
        ];
        
        return $Obj->update("Users",$data,"UserId=$chatId");
    
    }
    else{
    
    return bot('sendMessage',[
        'chat_id'=>$chatId,
        'text'=>"okeyt-".time()-(int)$LastTime,
        'parse_mode' => 'Markdown'
    ]); 
    }
}

function updateAllTeams() {
    global $Obj;
    global $liveScore;
    $Teams = $liveScore->getallteam();
    $count = 0;
    foreach ($Teams as $Team) {
        $ID = $Team->ID;
        $Nm = $Team->Nm ?? '-';
        $CoNm = $Team->CoNm ?? '-';
        $CoId = $Team->CoId ?? '-';
        $Img = $Team->Img ?? '-';
        $Stages = $liveScore->teaminfo($ID);
        $Stages0 = $Stages[0]->CompN ?? '-';
        $Stages1 = $Stages[1]->CompN ?? '-';
        
        $data = [
            'Id' => $ID,
            'Name' => $Nm,
            'CoName' => $CoNm,
            'CoId' => $CoId,
            'Img' => $Img,
            'Cnm' => $Stages0 . "||" . $Stages1
        ];
        if (!$Obj->has('Teams', ['Id' => $ID])) {
            $Obj->insert("Teams", $data);
            $count++;
        }
    }
    return $count;
}

function UpdateCountrys($chatId) {
    global $liveScore;
    global $Obj;
    for ($num = 0; $num < 90; $num++) {

        if ($num == 0) {
            $E = $num;
            $date = date('Ymd');
        } 
        // elseif ($num <= 90) {
        //     $E = $num;
        //     $date = date('Ymd', strtotime("-$num day"));
        // } 
        else {
            $E = $num+2;
            $date = date('Ymd', strtotime("+".($E - 3)." day"));
        }

        // sendMessage($chatId, "E : $E Day\n$date");

        $datas = $liveScore->alldata("$date");
        foreach ($datas as $data) {
            $CountryId = $data->Sid;
            $CountryName = $data->Csnm ?? "NoName";
            $CountryLig = $data->Snm; 
            $LigForTable = $data->Scd;
            $CountryImage = $data->badgeUrl ?? '-';
            $TableID=$data->CompId ?? '-';
            echo "\n--------------------\n";

            $data = [
                'CountryId' => $CountryId,
                'CompId' => $TableID,
                'Country' => $CountryName,
                'LigName' => $CountryLig,
                'CountryLink' => $CountryImage,
                'LigTable' => $LigForTable,
            ];
            
            if (!$Obj->has('Countys', ['CountryId' => $CountryId]) && $CountryName !== "NoName") {
                $Obj->insert("Countys", $data);
                print("$CountryId -- $CountryName -- $CountryLig -- $CountryImage\n");
            }
        }
        // sleep(1);
    }
}

function advancedBuild23($ButtunsId, $perline = 1, $json = true, $prefix = "", $suffix = ""){
    $keyboard = array();
    $n = $m = 0;
    $Num = 0;
    foreach ($ButtunsId as $button){
        $button = $Num + 1;
        if ((is_array($perline) && $perline[$m] == $n) || $n == $perline){
            $m++;
            $n = 0;
        }
        $keyboard[$m][] = ['text' => trim($prefix." ".$button." ".$suffix),'url'=>$ButtunsId[$Num]];
        $n++;
        $Num++;
    }
    if ((is_array($perline) && $perline[$m] == $n) || $n == $perline){
        $m++;
        $n = 0;
    }
    $keyboard[$m][] = ['text'=>" 📰 اخبار ورزشی ایران و جهان [جدید]",'callback_data'=>"ALLNEWS"];

    $keyboard[$m+1][] = ['text' => "Enter Live Scores Bot ✅",'callback_data'=>"Taeed"];

    return $json 
        ? json_encode([
            'inline_keyboard' => $keyboard,
            'resize_keyboard' => true
        ])
        : $keyboard;
}

function checkJoin($channels,$chatId,$StartInlineText,$MainKeyboard){
    global $Obj;

    // $condition = ['UserId' => $chatId];
    // $check = $Obj->select("Users", "HasJoin",$condition)[0]['HasJoin'];
    // if($check == "left" && count($channels) > 0){
    //     $E = advancedBuild23(array_values($channels),1,true,"کانال ");
    //     return sendMessage($chatId,$StartInlineText,$E,null);
    // }else{
        // return sendMessage($chatId,$StartInlineText);
        return sendMessage($chatId,$StartInlineText,$MainKeyboard,null);

    // }
}

function GETALLNEWS($Type,$inline_queryId) {
    global $Domain;
    if($Type=="ALL"){ 
        $url = "https://api.footballi.net/api/v2/news/latest?version=2";
    }elseif($Type=="IR"){
        $url = "https://api.footballi.net/api/v2/news/latest/2?version=2";
    }else{
        $url = "https://api.footballi.net/api/v2/news/latest/3?version=2";
    }
    $headers = [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:131.0) Gecko/20100101 Firefox/131.0',
        'Accept: */*',
        'Accept-Language: en-US,en;q=0.5',
        'Accept-Encoding: gzip, deflate, br',
        'Referer: https://www.livescore.com/',
        'Project: livescore.com',
        'Origin: https://www.livescore.com',
        'Sec-Fetch-Dest: empty',
        'Sec-Fetch-Mode: cors',
        'Sec-Fetch-Site: cross-site',
        'Authorization: Bearer [YOUR_TOKEN]',
        'Connection: keep-alive',
        'Priority: u=4',
        'TE: trailers',
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_ENCODING, '');
    $response = curl_exec($ch);
    curl_close($ch);
    $HH = json_decode($response, true);
    $results = [];


    if (isset($HH['data']['news'])) {
        $num = 0;
        foreach ($HH['data']['news'] as $data) {
            $title = str_replace(["به نقل از","فوتبالی","پایگاه خبری"],["","",""],$data['title']) ?? '-';
            $subtitle = str_replace(["به نقل از","فوتبالی","پایگاه خبری"],["","",""],$data['summary']) ?? '-';

            $IMG = $data['news_image'][0]['url']??"";
            $NAMEIMG = substr($IMG,-15,15);
            if (file_exists("./Tmp/$NAMEIMG")) {}else{copy($IMG,"./Tmp/$NAMEIMG");}

            $content_text = "";
            if($num < 5){

                $results[] = [
                    'id'                       => base64_encode(rand(0,9999)),
                    'title'                    => $title??"-",
                    'type'                     => 'article',
                    'description'              => $subtitle??"-",
                    'thumbnail_url'              => $IMG,
                    'input_message_content' => [
                        'message_text' => "*$title*\n\n$subtitle",
                        'parse_mode'=>'MarkDown',
                        'link_preview_options' => [
                            'is_disabled'=>false,
                            'url'=>"https://$Domain/LiveMrMD/Tmp/$NAMEIMG",
                            'prefer_small_media' => true,
                            'show_above_text' => true
                            
                            
                            ] 
                    ]
                ];
                $num +=1;
            }

        }
    }

        return answerInlineQuery($inline_queryId,0,$results);

}

if (isset($tgUserId) && $tgUserId) {
    track_event($tgUserId, 'open_bot'); // ثبت هر آپدیت
}

$update = json_decode(file_get_contents('php://input'), true);

require_once __DIR__ . '/track_client.php';
$tgUserId = $update['message']['from']['id']
  ?? $update['edited_message']['from']['id']
  ?? $update['callback_query']['from']['id']
  ?? $update['inline_query']['from']['id']
  ?? $update['chat_member']['from']['id']
  ?? $update['my_chat_member']['from']['id']
  ?? null;
if ($tgUserId) { track_event($tgUserId, 'open_bot'); }

$text = $chatType = $chatTitle = $userName = $firstName = $callbackId = $data = $query = $fromId = false;

if(isset($update['message']) || isset($update['edited_message'])) {
    $message    = $update['message'] ?? $update['edited_message'];
    $messageId  = $message['message_id'];
    $text       = $message['text'] ?? NULL;
    $chat       = $message['chat'];
    $chatId     = $chat['id'];
    $chatType   = $chat['type'] ?? NULL;
    $chatTitle  = $chat['title'] ?? 'UnKnown';
    $from       = $message['from'];
    $fromId     = $from['id'];
    $firstName  = $from['first_name'];
    $userName   = $from['username'] ?? 'Empty';
}

elseif(isset($update['callback_query'])) {
    $message    = $update['callback_query']['message'] ?? null;
    $chatId     = $message['chat']['id'] ?? NULL;
    $messageId  = $message['message_id'] ?? NULL;
    $fromId     = $update['callback_query']['from']['id'];
    $firstName  = $update['callback_query']['from']['first_name'];
    $userName   = $update['callback_query']['from']['username'] ?? 'Empty';
    $callback_query       = $update['callback_query']['data'] ?? NULL;
    $callbackId = $update['callback_query']['id'] ?? NULL;


}

elseif(isset($update['inline_query'])) {
    $inline_query    = $update['inline_query'] ?? null;
    $inline_queryId     = $update['inline_query']['id'] ?? NULL;

    $query     = $inline_query['query'] ?? NULL;
    $offset     = $inline_query['offset'] ?? NULL;
    $fromId     = $inline_query['from']['id'];
    $firstName  = $inline_query['from']['first_name'];
    $userName   = $inline_query['from']['username'] ?? 'Empty';
}

elseif(isset($update['chat_member'])) {
    $message    = $update['chat_member'] ?? null;
    $chatId     = $message['chat']['id'] ?? NULL;
    $Title     = $message['chat']['title'] ?? NULL;
    $fromId     = $message['from']['id'];
    $status  = $message['new_chat_member']['status'];
}

function adminSendMessageToUser($chat_id, $text) {
    global $bot_token;
    $url = "https://api.telegram.org/bot{$bot_token}/sendMessage";

    $post_fields = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];

    $opts = [
        "http" => [
            "method" => "POST",
            "header" => "Content-Type:application/x-www-form-urlencoded",
            "content" => http_build_query($post_fields)
        ]
    ];

    file_get_contents($url, false, stream_context_create($opts));
}


