<?php

require_once 'config.php';
require_once __DIR__ . "/data.php";
require_once __DIR__ . '/summary/summary_helpers.php';

try {
    $db = new PDO("mysql:host=localhost;dbname=$Db_Name;charset=utf8mb4", $Db_Username, $Db_Password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    file_put_contents("db_error_log.txt", "❌ DB Connection Error: " . $e->getMessage() . "\n", FILE_APPEND);
}

date_default_timezone_set('Asia/Tehran');

function isUserMember($userId, $channelUsername) {
    $result = bot('getChatMember', [
        'chat_id' => $channelUsername,
        'user_id' => $userId
    ]);
    
    // اگر تابع bot آرایه برمی‌گرداند، مستقیماً از آن استفاده کنید
    if (is_array($result) && isset($result['result']['status'])) {
        $status = $result['result']['status'];
        return in_array($status, ['member', 'administrator', 'creator']);
    }
    
    // اگر string برمی‌گرداند، decode کنید
    if (is_string($result)) {
        $data = json_decode($result, true);
        if(isset($data['result']['status'])) {
            $status = $data['result']['status'];
            return in_array($status, ['member', 'administrator', 'creator']);
        }
    }
    
    return false;
}
$channels = array (
    "-1002094740990"=>"https://t.me/playercubevideo"
    );
$ADMINID = 5571352499;

function generateErrorResponse(string $message): array
{
    return [[
        'id' => bin2hex(random_bytes(4)),
        'title' => $message,
        'type' => 'article',
        'description' => "",
        'input_message_content' => [
            'message_text' => $message,
            'parse_mode' => 'MarkDown',
        ],
    ]];
}

function GetLive($date,$chatId,$callbackId,$messageId,$PeerLine){
    global $liveScore;

    if($date == "Live"){
        $Lives = $liveScore->livescore();
        $PeerLine = 2;
    }else{
        $Lives = $liveScore->livescorebydate($date);
    }

    if(!$Lives or $Lives == "FALSE"){
        return bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=>"No live matches are currently being played.",
            'show_alert' => true
        ]); 

    }else{
        bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=>"Please wait...",
            'show_alert' => false
        ]); 
    }
    
    $ButtunsName = [];
    $ButtunsId = [];
$My_Ligs = [
    21997, 22091, 21862, 22118, 22180, 22694, 22724, 21841, 22024, 22001, 22225,
    22452, 20159, 20064, 22005, 21812, 21815, 21716, 22075, 21969, 22061, 22093,
    22862, 20094, 20095, 20096, 20097, 20098, 20099, 20100, 20101, 20102, 20103,
    20104, 20105, 14433, 22945, 22936, 22943, 22541, 22937, 23132, 22094, 22938,
    23138, 23139, 21891, 22095, 21970, 23590, 20065, 23783, 21971, 22076, 23579, 
    23722
];
    foreach($Lives as $Live){
        $Id = $Live->Sid;
        if(in_array((int)$Id,$My_Ligs)){
        $Name = $Live->Snm;
        $Continent = $Live->Cnm;
        $ButtunsName[] = $Name;
        $ButtunsId[] = "id-$date-".$Id;
        }

    }

    if(count($ButtunsName)>0){
        $keyboard = advancedBuild($ButtunsName,$ButtunsId,$PeerLine);
         editMessageText($chatId,$messageId,'Select your league:',$keyboard);
        
    }else{
        sendMessage($chatId, "No live matches are currently being played.");

         bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=>"No live matches are currently being played.",
            'show_alert' => true
        ]);

    }

}

$AdminKeyboard= json_encode([
    'resize_keyboard'=>true,
    'inline_keyboard'=> [
        [['text'=>"Status 📊",'callback_data'=>"Status"],['text'=>"FwdAll",'callback_data'=>"FwdAll"]],
        [['text'=>"sendToAll",'callback_data'=>"sendToAll"],['text'=>"Back",'callback_data'=>"LiveScore"]]
    ]
]);

$MainKeyboard= json_encode([
    'resize_keyboard'=>true,
    'inline_keyboard'=> [
        [['text' => "🤖 Enter the Bot", 'callback_data' => "LiveScore"]],
    ]
]);
 
$BackKeyboard= json_encode([
    'resize_keyboard'=>true,
    'inline_keyboard'=> [
        [['text'=>"Main Menu",'callback_data'=>"LiveScore"]]
    ]
]);

$MenuKeyboard = [
[['text'=>"🏆 Live Football Scores 🏆",'callback_data'=>"Live-Live"]],
    [
            // ['text'=>"🎞 Match Highlights",'callback_data'=>"SUMMARY"],
            ['text'=>"📡 Live Streams",'callback_data'=>"LG"],
        // ['text'=>"🕘 نتایج زنده",'callback_data'=>"Live-Live"]
    ],
// [['text'=>"📰 اخبار ورزشی ایران و جهان",'callback_data'=>"ALLNEWS"]],
// [['text'=>"💥 ورود به ربات پیش بینی فوتبال 💥",'url'=>"https://t.me/KickPredict_bot"]],
// [['text'=>"🎯 کانال گل‌تایم | گل‌های لحظه‌ای",'url'=>"https://t.me/GoalTiime"]],
[['text'=>"🎯 Goal Video Channel | Live Goals",'url'=>"https://t.me/playercubevideo"]],
// [['text'=>"🔖 Help",'switch_inline_query_current_chat'=>"Help"]],
// [['text'=>"🔧 Support",'callback_data'=>"SUPPORT"]],
];

$STARTTXT = "*Welcome 🤝 to Live Football Bot!*\n
⚽️ *Live Football Scores*  
🎥 *Live Stream Links*  

⬇️ Choose an option below to get started ⬇️

*To refresh the bot, always type /start again.*
";

if(isset($chatId) && in_array($chatId,ADMINS)){
        
    if ($text === '/UpdateTeams'){
        sendMessage($chatId,"wait ...");
        $Update = updateAllTeams();
        $TXT = "Ok Updated count : $Update";
        sendMessage($chatId,"$TXT");
    
}
     
    if ($text === '/UpdateCountrys'){
        $Obj->deleteAll('Countys');
        sendMessage($chatId,"wait ...");
        $Update = UpdateCountrys($chatId);
        $TXT = "Ok Updated count : $Update";
        sendMessage($chatId,"$TXT");
    
}

    if ($text === '/panel'){
        sendMessage($chatId,$StartText,$AdminKeyboard,null);
    
    }
    
    elseif($text == 'usage'){
        $memory = memory_get_usage(true)/1024/1024;
        sendMessage($chatId, "`Memory usage is ".$memory." Mb`");
    }

    elseif ($text === 'ping') {
        $start = microtime(true);
        $end   = microtime(true);
        $ping = round(($end - $start) * 1000, 3);
        sendMessage($chatId,"`Robot ping : $ping ms`");
    }
    
    elseif ($text === 'help'){
    
        
        $E = "راهنمای ربات : 

تست روشن بودن ربات : 
`ping`
مصرف ربات : 
`usage`

پنل ربات :
`/panel`
آپدیت تیم های ربات:
`/UpdateTeams`

آپدیت کشور های ربات : 
`/UpdateCountrys`";
    bot('sendMessage',['chat_id'=>$chatId,'text'=>$E,	'parse_mode'=>'Markdown']); 

    }
}

if (isset($text) && isset($chatId)) {
    global $db, $Domain; // قبل از استفاده

    // ثبت آخرین فعالیت کاربر
    $stmt = $db->prepare("UPDATE `Users` SET `LastVisit` = NOW() WHERE `UserId` = ?");
    $stmt->execute([$chatId]);

    $waiting_file = __DIR__ . "/support_waiting/{$chatId}.txt";
    file_put_contents("log_debug.txt", "🎯 فایل بررسی شد برای کاربر $chatId\n", FILE_APPEND);

    if (file_exists($waiting_file)) {
        unlink($waiting_file);

        $sql = "INSERT INTO `support_tickets` (`user_id`, `message`, `created_at`) VALUES (?, ?, NOW())";
        $stmt = $db->prepare($sql);

        if (!$stmt->execute([$chatId, $text])) {
            file_put_contents("test_ticket_debug.txt", "❌ خطا در اجرا: " . implode(", ", $stmt->errorInfo()) . "\n", FILE_APPEND);
        } else {
            file_put_contents("test_ticket_debug.txt", "✅ ذخیره موفق\n", FILE_APPEND);
        }

        sendMessage($chatId, "✅ Your message has been received. Support will respond soon.");
        // ارسال نوتیفیکیشن به ادمین
        $admin_id = 7016742199;
        $notifText = "📩 New support message received:\n\n👤 User: $chatId\n📝 Message: $text";
        sendMessage($admin_id, $notifText);
        return;
    }

    if (strpos($text, "start") !== false || $text == "Start✔️") {
        $data = "UserId=$chatId";
        $conditions = ['UserId' => $chatId];
        if (!$Obj->has('Users', $conditions)) {
            $data = [
                'UserId' => $chatId,
                '`Limit`' => time(),
                'Ban' => 0
            ];
            $Obj->insert("Users", $data);
        }

        $button_select_lan = json_encode([
            'resize_keyboard' => true,
            'inline_keyboard' => $MenuKeyboard
        ]);
        sendMessage($chatId, $STARTTXT, $button_select_lan, false);
    }
    elseif (preg_match("/(\d{8})\|([a-zA-Z\-]+)-(\d+)/", $text)) {
        sendByUpdate($text, $chatId, "send", '$messageId');
    }
    
    elseif($text == "/updateInlineTeams"){
        sendMessage($chatId,"wait ... ");

        $TXT = "";
        $Countrys = [
          "iran"   => 'pro-league',
          "england" => 'premier-league',
          "spain"   => 'laliga',
          "italy"   => 'serie-a',
          "germany"   => 'bundesliga',
          "france"   => 'ligue-1',
          "scotland"   => 'scotland-premiership',
          "portugal"   => 'primeira-liga',
          "saudi-arabia"   => 'saudi-professional-league',
          "belgium"   => 'belgian-pro-league',
          "usa"   => 'major-league-soccer',
          "poland"   => 'ekstraklasa'
        ];
        foreach ($Countrys as $Country => $LIG){
            $getTeams = json_decode(file_get_contents("https://prod-public-api.livescore.com/v1/api/app/stage/soccer/$Country/$LIG/3.30"));
            $Stages = $getTeams->Stages[0];
            $coName = $Stages->Cnm;
            $Lig = $Stages->Snm;
            if(isset($Stages->LeagueTable)){
                $Tables = $Stages -> LeagueTable->L[0]->Tables;
                foreach ($Tables as $Table){
                    $teams = $Table->team;
        
                    foreach ($teams as $team){
                        $name = $team->Tnm??'????';
                        $id = $team->Tid??'????';
                        $Img = $team->Img??'????';
                        // $Img = $team->Img??'????';
                        // $Img = $team->Img??'????';
                        $TXT .= "$name  -  $id  -  $Img  -- <br>";
                        
                        $conditions = ['Id' => $id];
                    
                        if(!$Obj->has('Teams', $conditions)){
                            $data = [
                                'Id' => $id,
                                'Name' => $name,
                                'PersianName' => $name,
                                'CoName' => $coName,
                                // 'CoId' => '0',
                                'Img' => $Img,
                                'Cnm' => $Lig
                            ];
                            $Obj->insert("Teams",$data);
                        }
                        
                    }
                }
            
            }
        
        }
        return sendMessage($chatId,"tamam :)");
    }
    
    elseif(strpos($text,'Help')!==false){
        $NUM = str_replace('Help','',$text);
        if($NUM == '0'){
            $InputMediaPhoto = [
            [
                'type' => 'video',
                'caption' => "⚽️راهنماى استفاده از نتايج زنده⚽
                ️\nدر اين صفحات، تمام نكات استفاده از بخش نتايج زنده را توضيح داده ايم.\n🎯تمام بازى هاى در حال برگزارى در باكس مورد نظر ظاهر مى شوند.\n🎯انتخاب كنيد و نتايج را دريافت كنيد.\n🎯براى ديدن نتايج ثانيه اى بر روى بروزرسانى كليك كنيد.
                \n🤤لذت ببريد.\n🔊@playercubevideo\n🤖@PlayersCubebot",
                'media' => 'BAACAgQAAxkBAALlx2g59ROrEVgPrUFRNXyZXlx9SCNOAAKpHAAChp3JUR5NvfGuAuUNNgQ'
            ]];
        }//نتایج زنده
        elseif($NUM == '1'){
        $InputMediaPhoto = [
        [
            'type' => 'video', 
            'caption' => '
⚽️ راهنمای استفاده از پخش زنده ⚽️

🎯 روی دکمه «پخش زنده» کلیک کنید.
🎯 برای دیدن بازی‌ها، فیلترشکن یا پراکسی خود را قطع کنید.
🎯 روی بازی مورد علاقه خود کلیک کنید.
🎯 روی لینک بزنید و لذت ببرید.

🔊 @PlayersCubebot
🤖 @playercubevideo            
',
            'media' => 'BAACAgQAAxkBAALlyWg59RlYu7sMT_oXWZKSEYT9cBvOAAKqHAAChp3JUXeFdGxjUlbRNgQ',
        ]];
        }//پخش زنده  
        elseif($NUM == '2'){
            $InputMediaPhoto = [
            [
                'type' => 'video', 
                'caption' => "⚽️راهنمای استفاده از اخبار ورزشی⚽
                ️\n🎯پس از ورود به ربات، اخبار ورزشی را انتخاب کنید.\n🎯یک لیست برای شما باز میشود که درآن جدیدترین خبرها از تمام خبرگزاری ها وجود دارد. خبر مورد نظر خود را انتخاب کنید.\n🎯لینک نمایش داده شده در پیام را کلیک کنید و مرجع اصلی خبر را بخوانید.
                \n🤤لذت ببريد.\n🔊@playercubevideo\n🤖@PlayersCubebot",
                'media' => 'BAACAgQAAxkBAALly2g59SBgRwn0jKWl27-sbVyQ7uBcAAKrHAAChp3JUQwHs9A6xFi_NgQ'
            ]];
        }//اخبار 
        elseif($NUM == '3'){
            $InputMediaPhoto = [
            [
                'type' => 'video',
            'caption' => '⚽️ راهنمای استفاده از جدول‌ها ⚽️
🎯 روی دکمه «جدول لیگ‌ها» کلیک کنید.
🎯 لیگ‌های برتر دنیا به‌صورت تصادفی برای شما نمایش داده می‌شوند.
🎯 هرکدام را که خواستید باز کنید. در غیر این صورت:
🎯 در باکس نوشتار، نام کشور مورد نظر را به انگلیسی وارد کنید.
🎯 تمام لیگ‌های آن کشور ظاهر می‌شوند. لیگ مورد نظر را انتخاب کرده و جدول را دریافت کنید.
            
🤤 لذت ببرید.
            
🔊 @PlayersCubebot
🤖 @playercubevideo
',

                'media' => 'BAACAgQAAxkBAALlzmg59SbIER2NbPwjikAtq3F6xsMlAAKtHAAChp3JUczL9ny1miOSNgQ'
            ]];
        }//جدول
        elseif($NUM == '4'){
            $InputMediaPhoto = [
            [
                'type' => 'video', 
                'caption' => "⚽️راهنماى استفاده از جستجو بر اساس تاریخ
                ️\n🎯تاريخ ها به صورت ميلادى وارد شده اند.\n🎯ساعت بازى ها بر اساس، ساعت ايران تنظيم شده است.\n🎯تاريخ امروز با تيك مشخص شده است.\n🎯تاريخ مورد نظر خود را انتخاب كنيد، در باكس كشور مورد نظر را به لاتين وارد كنيد.\n🎯تمام ليگهاى آن كشور ظاهر ميشوند. گزينه مورد نظر را انتخاب كنيد و نتايج را دريافت كنيد.\n🎯در صورتى كه در تاريخ مشخص شده، بازى وجود نداشته باشد، پيام دريافت خواهيد كرد.
                \n🤤لذت ببريد.\n🔊@playercubevideo\n🤖@PlayersCubebot",
                'media' => 'BAACAgQAAxkBAALl02g59SyU_unrDQlzpEyq7Y2bSp2XAAKuHAAChp3JUVmE91khVU0VNgQ'
            ]];
        }//تقویم
        elseif($NUM == '5'){
            $InputMediaPhoto = [
            [
                'type' => 'video', 
                'caption' => "⚽️راهنمای استفاده از جستجو بر اساس نام باشگاه⚽️
                \n🎯 بعد از انتخاب جستجو بر اساس نام باشگاه، در باکس نوشتار، به لاتین، تیم مورد نظر خود را وارد کنید.\n🎯 بعد از انتخاب تیم مورد نظر، بازی های انجام شده و بازی های آینده تیم مشخص میشود.\n🎯 با انتخاب هر کدام میتوانید از نتایج گذشته یا بازی های آینده تیم مورد علاقه خود باخبر شوید.
                \n🤤لذت ببريد.\n🔊@playercubevideo\n🤖@PlayersCubebot",
                'media' => 'BAACAgQAAxkBAALl1mg59TP3JX2J9Ge3w3M1WP1gRV0DAAKvHAAChp3JUQSnTmqjOLmjNgQ'
            ]];
        }
        //باشگا
        bot('sendMediaGroup',[
            'chat_id' => $chatId,
            'media' => json_encode($InputMediaPhoto)
        ]);
    }
}

if(isset($inline_query)){
    global $Domain;

if(preg_match("/search (.*\d) country_(.*)/i", $query)){
    preg_match("/search (.*\d) country_(.*)/i", $query,$m);

    $Date = $m[1];
    $query = substr($m[2]??'-',0);

    if($query == '-' or strlen($query)<=1){
        $results = [];
        $Ligs = ['England','Italy','Spain','France','Germany'];
        $Ligs = ['England||Premier-League||21997','Germany||Bundesliga||22091','Italy||Serie A||21862','Spain||Laliga||22180','France||Ligue-1||22118'];

        foreach($Ligs as $Lig){
            $explode = explode('||',$Lig);
            $CID = $explode[2];;
            $CNAME = $explode[0];
            $CLIG = $explode[1];

            $results[] = [
                'id'                       => base64_encode(rand(0,9999)),
                'title'                    => "$CNAME",
                'type'                     => 'article',
                'description'              => "$CLIG",
                'thumbnail_url'                 => "https://static.livescore.com/i2/fh/".strtolower($CNAME).".jpg",
                
                'input_message_content' => [
                    'message_text' => "$Date|$CLIG-$CID",
                    'parse_mode'=>'MarkDown',
                    'disable_web_page_preview' => true ,
                ]
            ];
        }

        return answerInlineQuery($inline_queryId,300,$results);

    }

    $search = $Obj->select('Countys', '*', ['Country[~]' => $query]);

    $results = resultsx($search,$Date);
    return answerInlineQuery($inline_queryId,300,$results);
    
}

elseif(preg_match("/Help(.*)/i", $query)){
    $results = [];
    $Helps = [
        'راهنمای نتایج زنده',
        'راهنمای پخش زنده',
        'راهنمای اخبار ایران و جهان',
        // 'راهنمای جدول لیگ ها',
        // 'راهنمای تقویم بازی ها',
        // 'راهنمای برنامه و نتایج بازی های باشگاه'
    ];
    $num = 0;
    foreach($Helps as $Help){        $results[] = [
            'id'                       => base64_encode(rand(0,9999)),
            'title'                    => "$Help",
            'type'                     => 'article',
            'description'              => "",
            'thumbnail_url'            => "https://playerscube1.site/LiveMrMD/HELPLOGO10.jpg",
            
            'input_message_content' => [
                'message_text' => "Help$num",
                'parse_mode'=>'MarkDown',
                'disable_web_page_preview' => false ,
            ]
        ];
        $num=$num+1;
    }
    return answerInlineQuery($inline_queryId,300,$results);
}

elseif(strpos($query,"ALLNEWS-") !== false or strpos($query,"pop_NEWS-") !== false){
    
if($query == "ALLNEWS-"){
        $data = json_decode(file_get_contents("https://$Domain/GetData/news/news_data.json"),true);
        $datas = array_reverse(array_slice($data, - 50));

    
}elseif($query == "pop_NEWS-"){
        $data = json_decode(file_get_contents("https://$Domain/GetData/news/popular.json"),true);
        $datas = array_reverse(array_slice($data, - 50));
    }
    
    $totalEntries = count($data);
    $results = [];

if (isset($datas)) {
        $num = 0;
        foreach ($datas as $data) {
            $title = $data['text'];
            $subtitle = "";
            if($data['img'] !== "Default.jpg"){
                $IMG = "https://$Domain/GetData/news/photos/".$data['img']??'';
            }else{
                $IMG = "https://$Domain/GetData/news/".$data['img']??'';
            }
            $Link = $data['link'];

            $content_text = "";
            if($num < 50){
                $MKeyboard = [
                    [['text' => '🗞️ سایر خبرها', 'switch_inline_query_current_chat' => 'ALLNEWS-']],
                ];
                $MainKeyboard= [
                    'inline_keyboard'=>$MKeyboard
                ];
                $results[] = [
                    'id'                       => base64_encode(rand(0,9999)),
                    'title'                    => $title??"-",
                    'type'                     => 'article',
                    'description'              => $subtitle??"-",
                    'thumbnail_url'              => $IMG,
                    'input_message_content' => [
                        'message_text' => "*$title*\n\n "."[برای دریافت لینک خبر، اینجا کلیک کنید!]($Link)",
                        'parse_mode'=>'MarkDown',
                        'link_preview_options' => [
                            'is_disabled'=>false,
                            'url'=>$IMG,
                            'prefer_small_media' => true,
                            'show_above_text' => true
                            ] 
                    ],
                    'reply_markup'=>$MainKeyboard

                ];
                $num +=1;
            }

        }
    }

        return answerInlineQuery($inline_queryId,0,$results);
}
 
elseif(strpos($query,"IRNEWS-") !== false){
    GETALLNEWS("IR",$inline_queryId);
}

elseif(strpos($query,"NEWS-") !== false){
    GETALLNEWS("NEWS",$inline_queryId);
}

elseif(strpos($query,"Team-") !== false){
    $query = str_replace("Team-","",(string)$query);

    $search = $Obj->select('Teams', '*', ['Name[~]' => $query]);


    $results = results($search);
    answerInlineQuery($inline_queryId,0,$results);
}

if($query == "Fgames"){
    answerInlineQuery($inline_queryId,300,Future_game());
}
}

if(isset($callback_query)){
    $callback_data = $callback_query['data'] ?? null;
    if ($callback_query == "SUPPORT") {
    sendMessage($chatId, "📝 Please send your message for support.\n\n(Only send one text message)");
    file_put_contents(__DIR__ . "/support_waiting/{$chatId}.txt", "waiting");
    return;
    }

    if($callback_query == "Taeed"){
    answerCallbackQuery($callbackId, "Please wait...");

        return sendMessage($chatId,$StartInlineText,$MainKeyboard,null);
    }
    
    if($callback_query == 'Status'){
        $AllUsers = $Obj->count("Users");
        $txt = "All Users : $AllUsers";
        editMessageText($chatId,$messageId,$txt,$AdminKeyboard);
    }

    if($callback_query == 'Back'){
            editMessageText($chatId,$messageId,$StartText,$MainKeyboard);
    }

    elseif($callback_query == "Help"){
        answerCallbackQuery($callbackId,"منتظر بمانید ...");
        sendMessage($chatId,$Help,$HelpKeyboard,null);
    }
    
    elseif(preg_match("/(\d*4)(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])\|(\w.*)-(\d.*)/i", $callback_query)){
        sendByUpdate($callback_query,$chatId,"edit",$messageId);
    }

    elseif($callback_query == 'LiveScore' or $callback_query == 'LiveScore2'){
            $button_select_lan=
            json_encode(
                [
                'resize_keyboard'=>true,
                'inline_keyboard'=>$MenuKeyboard
            ]);

            if($callback_query == 'LiveScore2'){
            return sendMessage($chatId,$STARTTXT,$button_select_lan,false);
            }
            editMessageText($chatId,$messageId,$STARTTXT,$button_select_lan);

    }

    elseif ($callback_query === 'SUMMARY') {
        $kb = summary_categories_keyboard();
        editMessageText($chatId, $messageId, "⚽️ To watch your favorite match, please select your league.", $kb);
    }
    
    elseif (strpos($callback_query, 'SUMCAT_') === 0) {
    $cat = substr($callback_query, strlen('SUMCAT_')); // 'laliga' | 'epl' | 'iran' | 'other'
    $title = summary_category_title($cat);
    $kb = summary_list_keyboard($cat);
    editMessageText($chatId, $messageId, "📲 Select your favorite match and enjoy watching it. $title »", $kb);
    }

    elseif(strpos($callback_query,"|-id-")!==false){
        $callback_query = str_replace("|-","",$callback_query);

        sendById($callback_query,$chatId,$callbackId,'edit',$messageId);

    }
    
    elseif(strpos($callback_query,"id-")!==false){
        sendById($callback_query,$chatId,$callbackId,'send',$messageId);

    }

    elseif(strpos($callback_query,"Live-")!==false){
        $date = str_replace("Live-","",$callback_query);
        GetLive($date,$chatId,$callbackId,$messageId,2);
    }
    
elseif($callback_query == "LG"){
    bot('answerCallbackQuery',[
        'callback_query_id'=>$callbackId,
        'text'=> "Please wait...",
        'show_alert' => false
    ]);
    
    // Step 1: Ask to join channel
    $joinKeyboard = json_encode([
        'inline_keyboard' => [
            [['text' => "📢 Join Channel", 'url' => "https://t.me/playercubevideo"]],
            [['text' => "✅ Check Membership", 'callback_data' => "LG_CHECK"]]
        ]
    ]);
    
    return editMessageText($chatId, $messageId, 
        "⚠️ *Channel Membership Required*\n\n" .
        "To access live streams, please join our channel first:\n" .
        "🔗 @playercubevideo\n\n" .
        "After joining, click '✅ Check Membership' to verify.",
        $joinKeyboard
    );
}

// Add this new callback for checking membership
elseif($callback_query == "LG_CHECK"){
    bot('answerCallbackQuery',[
        'callback_query_id'=>$callbackId,
        'text'=> "Checking membership...",
        'show_alert' => false
    ]);
    
    // Check if user is member of channel
    $channelUsername = "@playercubevideo";
    $isMember = isUserMember($chatId, $channelUsername);
    
    if(!$isMember) {
        bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=> "❌ You haven't joined the channel yet!",
            'show_alert' => true
        ]);
        
        $joinKeyboard = json_encode([
            'inline_keyboard' => [
                [['text' => "📢 Join Channel", 'url' => "https://t.me/playercubevideo"]],
                [['text' => "✅ Check Again", 'callback_data' => "LG_CHECK"]]
            ]
        ]);
        
        return editMessageText($chatId, $messageId, 
            "❌ *Membership Not Verified*\n\n" .
            "You haven't joined our channel yet!\n" .
            "🔗 @playercubevideo\n\n" .
            "Please join first, then click '✅ Check Again'.",
            $joinKeyboard
        );
    }
    
    // User is member, show streams
    $OptionsKeyboard = [
        [['text'=>"🌐 International Streams 1",'url'=>"https://gr.league.do/index?sport=Football"]],
        [['text'=>"🌐 International Streams 2",'url'=>"https://www.matches-today.com/"]],
        [['text'=>"⬅️ Back to Menu",'callback_data'=>"LiveScore"]]
    ];

    $button_select_lan = json_encode([
        'resize_keyboard'=>true,
        'inline_keyboard'=>$OptionsKeyboard
    ]);
    
    bot('answerCallbackQuery',[
        'callback_query_id'=>$callbackId,
        'text'=> "✅ Access granted! Enjoy the streams.",
        'show_alert' => false
    ]);
    
    return editMessageText($chatId, $messageId,
        "🌐 *Live Stream Links*\n\n" .
        "🔗 **Available Streams:**\n" .
        "• International Streams 1\n" .
        "• International Streams 2\n\n" .
        "💡 *Thank you for joining our channel!*\n" .
        "🎥 Enjoy the streams!",
        $button_select_lan
    );
}    

    elseif(strpos($callback_query,"next-")!==false or strpos($callback_query,"prev-")!==false )
    {
        $Month = str_replace(['next-','prev-'], ['',''], $callback_query);
        if(strlen($Month)==1){
            $Month = "0$Month";
        }

        $date = DateTime::createFromFormat('Ym', date("Y").$Month);

        editMessageText($chatId,$messageId,$date->format('F')." ".date("Y"),json_encode(createCalendar(date("Y"), $Month)));

    }

    elseif($callback_query == "ALLNEWS" ){
        bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=>"لطفا صبر کنید",
            'show_alert' => false
        ]);
        $OptionsKeyboard = [
            [['text'=>"📰 اخبار روز",'switch_inline_query_current_chat'=>"ALLNEWS-"]],
            [['text'=>"🔥 پربازدیدترین خبرها",'switch_inline_query_current_chat'=>"pop_NEWS-"]],
            [['text'=>"Main Menu",'callback_data'=>"LiveScore"]]
        ];

        $button_select_lan=
        json_encode(
            [
            'resize_keyboard'=>true,
            'inline_keyboard'=>$OptionsKeyboard
        ]);
        return sendMessage($chatId,
'📢 *آخرین و مهم‌ترین خبرهای فوتبال!*

🟢 جدیدترین اخبار روز فوتبال
🔴 پرحاشیه ترین خبرها',
        $button_select_lan,false);
    }
    
    else{
        return bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=>"$callback_query",
            'show_alert' => true
        ]);

    }
}

if(isset($status)){

    if($status == "left" && isset($channels["$chatId"])){
        $conditions = ['UserId	' => $fromId];
        if($Obj->has("Users", $conditions)){
            $data = ['HasJoin' => "left"];
            $condition = "UserId=$fromId";
            $Obj->update("Users", $data, $condition);
            $TXT = "You left the channel $Title!\nUse this link to rejoin:\n".$channels[$chatId];
            return bot('sendMessage',['chat_id'=>$fromId,'text'=>$TXT]); 
        }
    }
}
