<?php

// class LiveScore {
//     function getLink(string $url, string $method = 'GET', array $params = [], array $headers = [], bool $decode = false, int $timeout = 15) {
//         if ($method == 'GET' && count($params) > 0) {
//             $url = $url . '?' . http_build_query($params);
//         }
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
//         curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
//         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//         if ($method == 'POST') {
//             curl_setopt($ch, CURLOPT_POST, true);
//             curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
//         }
//         if (count($headers) > 0) {
//             curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         }
//         $response = curl_exec($ch);
//         if (curl_errno($ch)) {
//             error_log("cURL Error for $url: " . curl_error($ch));
//             curl_close($ch);
//             return false;
//         }
//         curl_close($ch);
//         return $decode ? json_decode($response, true) : $response;
//     }

//     function fetchWithCache($url, $ttl = 300) {
//         $cacheDir = __DIR__ . '/cache';
//         if (!file_exists($cacheDir)) {
//             mkdir($cacheDir, 0755, true);
//         }

//         $cacheKey = md5($url);
//         $cacheFile = "$cacheDir/$cacheKey.json";

//         if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $ttl) {
//             return file_get_contents($cacheFile); // خوندن از فایل کش
//         }

//         $response = $this->getLink($url);
//         if ($response !== false) {
//             file_put_contents($cacheFile, $response); // ذخیره توی کش
//             return $response;
//         }

//         return false;
//     }

//     public function livescore() {
//         $Link = "https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30";
//         $response = $this->getLink($Link);
//         if ($response === false) return false;
//         $Lives = json_decode($response)->Stages ?? 0;
//         return $Lives;
//     }

//     public function livescorebydate($date) {
//         $Link = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/$date/3.30?countryCode=FR&locale=en&MD=1";
//         $response = $this->getLink($Link);
//         if ($response === false) return "FALSE";
//         $data = json_decode($response);
//         return isset($data->Stages) ? $data->Stages : "FALSE";
//     }

//     public function getallteam() {
//         $Link = "https://search-api.livescore.com/api/v2/search/soccer/team?limit=200&locale=en&countryCode=DE&sCategories=true&sStages=true";
//         $data = $this->fetchWithCache($Link, 600000);
//         if ($data === false) return false;
//         $Get = json_decode($data);
//         return $Get->Teams ?? [];
//     }

//     public function teaminfo($teamid) {
//         $Link = "https://prod-cdn-team-api.livescore.com/v1/api/app/team/$teamid/details?locale=en&MD=1";
//         $data = $this->fetchWithCache($Link, 60000);
//         if ($data === false) return false;
//         $Get = json_decode($data);
//         return $Get->Stages ?? [];
//     }

//     public function alldata($date) {
//         $Link = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/$date/3.30";
//         $response = $this->fetchWithCache($Link, 6000000);
//         if ($response === false) return false;
//         $Lives = json_decode($response)->Stages ?? 0;
//         return $Lives;
//     }

//     public function livescore_search($Query) {
//         $Link = "https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30";
//         $response = $this->getLink($Link); // استفاده از کش
//         if ($response === false) return "خطا در دریافت اطلاعات";
//         $data = json_decode($response)->Stages ?? 0;

//         if ($data === 0) {
//             return "درحال حاضر هیچ بازی در حال برگزاری نیست";
//         }

//         $data = json_decode(json_encode($data), true); // تبدیل به آرایه
//         if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
//             return "داده نامعتبر";
//         }

//         $filteredData = array_filter($data, function($item) use ($Query) {
//             return isset($item['CnmT']) && $item['CnmT'] === $Query;
//         });
//         return array_values($filteredData);
//     }

//     public function GetTable($country, $Lig) {
//         $Link = "https://prod-public-api.livescore.com/v1/api/app/stage/soccer/$country/$Lig/3.30?locale=en&MD=1";
//         $response = $this->fetchWithCache($Link, 6000);
//         if ($response === false) return false;
//         $data = json_decode($response)->Stages[0]->LeagueTable->L[0]->Tables[0]->team ?? 0;
//         return $data;
//     }
// }

class LiveScore{
    function getLink( string $url,string $method = 'GET', array $params = [],array $headers = [],bool $decode = false,int $timeout = 15)
    {
        if ($method == 'GET' and count($params) > 0)
        {
            $url = $url . '?' . http_build_query($params);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        if ($method == 'POST')
        {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        }
        if (count($headers) > 0)
        {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        $response = curl_exec($ch);
        if ($decode == true)
        {
            $response = json_decode($response, true);
        }
        curl_close($ch);
        return $response;
    }
    function fetchWithCache($url, $ttl = 300) {
        $cacheKey = md5($url);
        $cacheFile = "./cache/$cacheKey.json";
        if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $ttl) {
            return $this->getLink($cacheFile);
        }
    
        // $response = openLink($url, 'GET');
        $response = $this->getLink($url);
        file_put_contents($cacheFile, $response);
        return $this->getLink($response);
    }

    public function livescore(){
        $Link = "https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30";
        // $response = $this->fetchWithCache($Link, 300); 
        $response = $this->getLink($Link);
        $Lives = json_decode($response)->Stages??0;
        if($Lives){
            // return array_slice($Lives, 0, 20);
            return ($Lives);
        }
    }

    public function livescorebydate($date){
        $Link = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/$date/3.30?countryCode=FR&locale=en&MD=1";
        $response = $this->getLink($Link);
        // $response = $this->fetchWithCache($Link, 300); 

        if(isset(json_decode($response)->Stages)){
            return $Lives = json_decode($response)->Stages??"FALSE";

        }else{
            return "FALSE";
        }
    }

    public function getallteam(){
        // $Link = "https://search-api.livescore.com/api/v2/search/soccer/team?limit=200&locale=en&countryCode=DE&sCategories=true&sStages=true";
        $Link = "https://prod-cdn-search-api.livescore.com/api/v2/search/soccer?query=estegh&limit=200&locale=en&countryCode=FI&categories=true&stages=true&teams=true";
        // $response = $this->fetchWithCache($Link,600);
        $response = $this->getLink($Link); 

        $Get = json_decode($response);
        $Teams = $Get ->Teams ;
        return $Teams;
    }

    public function teaminfo($teamid){
        $Link = "https://prod-cdn-team-api.livescore.com/v1/api/app/team/$teamid/details?locale=en&MD=1";
        // $response = $this->fetchWithCache($Link,6000);
        $response = $this->getLink($Link); 
        $Get = json_decode($response);
        $Stages = $Get->Stages;
        return $Stages;
    }

    public function alldata($date){
        $Link = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/$date/3.30";
        // $response = $this->fetchWithCache($Link,600);
        $response = $this->getLink($Link);
        $Lives = json_decode($response)->Stages??0;
        return $Lives;
    }

    public function livescore_search($Query){
        global $liveScore;
        $Link = "https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30";
        $response = $this->getLink($Link);
        // $response = $this->fetchWithCache($Link,600);
        $data = json_decode($response)->Stages??0;
        // $data = $liveScore->livescore();
        // if(count($data)>0){

        $data = json_decode(json_encode($data), true); 

        if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
            die('Invalid JSON data');
        }

        if($data !== null){
        $filteredData = array_filter($data, function($item) use ($Query) {
            return $item['CnmT'] === $Query;
        });
            return $filteredData = array_values($filteredData); 
        }else{
            return "درحال حاضر هیچ بازی در یورو در حال برگزاری نیست";   
        }
        // }else{
        //     return 'FALSE';
        // }
        
    }
    
    public function GetTable($country,$Lig){
        global $liveScore;

        $Link = "https://prod-public-api.livescore.com/v1/api/app/stage/soccer/$country/$Lig/3.30?locale=en&MD=1";
        // $Link = "https://prod-cdn-public-api.livescore.com/v1/api/app/competition/$ligId/leagueTable/?locale=en";
        $response = $this->getLink($Link);
        // $response = $this->fetchWithCache($Link,600);
        $data = json_decode($response)->Stages[0]->LeagueTable->L[0]->Tables[0]->team??0;
        return $data;
    }

}


// https://prod-cdn-public-api.livescore.com/v1/api/app/competition/65/leagueTable/?locale=en


