<?php

class Database {
    private $connection;

    public function __construct(array $options) {
        try {
            $dsn = "mysql:host=localhost;dbname={$options['dbname']}";
            $this->connection = new PDO($dsn, $options['username'], $options['password']);
            $this->connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            throw new Exception("Connection Failed: " . $e->getMessage());
        }
    }

    public function __destruct() {
        $this->connection = null;
    }

    private function executeStatement($sql, array $parameters = []) {
        $stmt = $this->connection->prepare($sql);
        $stmt->execute($parameters);
        return $stmt;
    }

    public function insert($table, $data) {
        $keys = implode(',', array_keys($data));
        $placeholders = implode(',', array_fill(0, count($data), '?'));
        $sql = "INSERT INTO $table ($keys) VALUES ($placeholders)";
        return $this->executeStatement($sql, array_values($data))->rowCount();
    }

    public function update($table, $data, $condition) {
        $setParts = [];
        foreach ($data as $key => $value) {
            $setParts[] = "$key = ?";
        }
        $setClause = implode(', ', $setParts);
        $sql = "UPDATE $table SET $setClause WHERE $condition";
        return $this->executeStatement($sql, array_values($data))->rowCount();
    }

    public function delete($table, $condition) {
        $sql = "DELETE FROM $table WHERE $condition";
        return $this->executeStatement($sql)->rowCount();
    }
    
    public function deleteAll($table) {
        $sql = "DELETE FROM $table";
        return $this->executeStatement($sql)->rowCount();
    }
    
    public function select($table, $columns = "*", $conditions = []) {
        $conditionStrings = [];
        $parameters = [];
        foreach ($conditions as $key => $value) {
            // بررسی ویژگی‌های خاص مانند جستجوی مبهم
            if (preg_match('/\[(\~)\]$/', $key, $matches)) {
                // حذف کاراکترهای خاص از کلید
                $key = preg_replace('/\[\~\]$/', '', $key);
                // افزودن % به انتهای مقدار برای جستجوی مبهم
                $value = "$value%";
                // ساخت رشته شرط
                $conditionStrings[] = "$key LIKE ?";
            } else {
                // برای شرایط عادی
                $conditionStrings[] = "$key = ?";
            }
            $parameters[] = $value;
        }
        $conditionString = implode(' AND ', $conditionStrings);
        $sql = "SELECT $columns FROM $table WHERE $conditionString";
        $stmt = $this->executeStatement($sql, $parameters);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function select2($table, $columns = "*", $conditions = []) {
        $conditionStrings = [];
        $parameters = [];
    
        foreach ($conditions as $key => $value) {
            $conditionStrings[] = "$key = ?";
            $parameters[] = $value;
        }
    
        $conditionString = implode(' AND ', $conditionStrings);
        $sql = "SELECT $columns FROM $table WHERE $conditionString";
    
        try {
            $stmt = $this->executeStatement($sql, $parameters);
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            echo "SQL Error: " . $e->getMessage();
            return [];
        }
    }

    public function has($table, $conditions) {
        $conditionStrings = [];
        $parameters = [];
        foreach ($conditions as $key => $value) {
            $conditionStrings[] = "$key = ?";
            $parameters[] = $value;
        }
        $conditionString = implode(' AND ', $conditionStrings);
    
        $sql = "SELECT COUNT(*) FROM $table WHERE $conditionString";
        $stmt = $this->executeStatement($sql, $parameters);
        $count = $stmt->fetchColumn();
    
        return $count > 0;
    }

    public function selectAll($table, $columns = "*") {
        $sql = "SELECT $columns FROM $table";
        $stmt = $this->executeStatement($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getMaxValue($table, $column) {
        $sql = "SELECT MAX($column) AS max_value FROM $table";
        $result = $this->executeStatement($sql)->fetch(PDO::FETCH_ASSOC);
        return $result['max_value'];
    }

    public function getMinValue($table, $column) {
        $sql = "SELECT MIN($column) AS min_value FROM $table";
        $result = $this->executeStatement($sql)->fetch(PDO::FETCH_ASSOC);
        return $result['min_value'];
    }

    public function count($table) {
        $sql = "SELECT COUNT(*) AS total_rows FROM $table";
        $result = $this->executeStatement($sql)->fetch(PDO::FETCH_ASSOC);
        return $result['total_rows'];
    }

    public function updateLastVisit($userId) {
    $sql = "UPDATE Users SET LastVisit = NOW() WHERE UserId = ?";
    return $this->executeStatement($sql, [$userId])->rowCount();
}
}

    
