<?php

function summary_load_matches(): array {
    $file = __DIR__ . '/summary_matches.php';
    $data = is_file($file) ? include $file : [];
    return is_array($data) ? $data : [];
}

function summary_category_title(string $key): string {
    $map = [
        'laliga' => 'LaLiga Spain',
        'epl'    => 'English Premier League',
        'iran'   => 'Iran Pro League',
        'bl'     => 'Bundesliga Germany',
        'fl'     => 'Ligue 1 France',
        'sa'     => 'Serie A Italy',
        'other'  => 'Other Matches',
    ];
    return $map[$key] ?? $key;
}

function summary_categories_keyboard(): string {
    $kb = [
        'resize_keyboard' => true,
        'inline_keyboard' => [
            [ ['text' => '🇪🇸 LaLiga Spain',             'callback_data' => 'SUMCAT_laliga'] ],
            [ ['text' => '🏴󠁧󠁢󠁥󠁮󠁧󠁿 English Premier League',  'callback_data' => 'SUMCAT_epl'] ],
            [ ['text' => '🇩🇪 Bundesliga Germany',      'callback_data' => 'SUMCAT_bl' ]],
            // [ ['text' => 'Iran Pro League',         'callback_data' => 'SUMCAT_iran'] ],
            [ ['text' => '🇫🇷 Ligue 1 France',          'callback_data' => 'SUMCAT_fl'] ],
            [ ['text' => '🇮🇹 Serie A Italy',           'callback_data' => 'SUMCAT_sa'] ],
            [ ['text' => '🏁 Other Matches',           'callback_data' => 'SUMCAT_other'] ],
            [ ['text' => 'Back',                    'callback_data' => 'LiveScore'] ],
        ]
    ];
    return json_encode($kb, JSON_UNESCAPED_UNICODE);
}

function summary_list_keyboard(string $cat): string {
    $all = summary_load_matches();
    $rows = [];

    if (!empty($all[$cat]) && is_array($all[$cat])) {
        foreach ($all[$cat] as $item) {
            // Each match as a URL button
            $rows[] = [ ['text' => $item['text'], 'url' => $item['url']] ];
        }
    } else {
        // If no items found
        $rows[] = [ ['text' => 'No items available at the moment', 'url' => 'https://t.me/GoalTiime'] ];
    }

    // Footer rows (back to leagues & main menu)
    $rows[] = [ ['text' => 'Back to Leagues', 'callback_data' => 'SUMMARY'] ];
    $rows[] = [ ['text' => 'Main Menu', 'callback_data' => 'LiveScore'] ];

    $kb = [
        'resize_keyboard' => true,
        'inline_keyboard' => $rows
    ];
    return json_encode($kb, JSON_UNESCAPED_UNICODE);
}
