<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *'); // یا دامنه مینی‌اپت
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, X-Track-Secret');

// پاسخ به preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(204);
  exit;
}

require_once __DIR__ . '/data.php';

try {
  $pdo = new PDO(
    "mysql:host=localhost;dbname={$Db_Name};charset=utf8mb4",
    $Db_Username,
    $Db_Password,
    [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]
  );
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>0,'err'=>'db_connect','msg'=>$e->getMessage()]);
  exit;
}

$TRACK_SECRET = 'MY_SUPER_SECRET_123';

/* --- احراز هویت ساده با هدر --- */
$secret = $_SERVER['HTTP_X_TRACK_SECRET'] ?? '';
if ($secret !== $TRACK_SECRET) {
  http_response_code(401);
  echo json_encode(['ok'=>0,'err'=>'unauthorized']); exit;
}

/* --- ورودی --- */
$raw = file_get_contents('php://input');
$in  = json_decode($raw, true);
if (!is_array($in)) { $in = $_POST; }

$provider   = $in['provider']   ?? 'telegram'; // telegram | miniapp | web | guest
$externalId = trim((string)($in['external_id'] ?? '')); // برای تلگرام: همون user_id تلگرام
$source     = $in['source']     ?? 'miniapp';   // bot | miniapp | web
$eventType  = $in['event_type'] ?? 'open_app';
$sessionId  = $in['session_id'] ?? null;
$meta       = $in['meta'] ?? null;
$ua         = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ip         = $_SERVER['REMOTE_ADDR'] ?? '';

if ($externalId === '') {
  http_response_code(400);
  echo json_encode(['ok'=>0,'err'=>'external_id required']); exit;
}

/* --- user_id واحد (بدون دست‌زدن به ساختار Users) --- */
/* فرض: در ربات، ستون Users.UserId همان Telegram user id است. */
$userId = (int)($in['user_id'] ?? 0);
if ($userId <= 0) {
  // اگر از تلگرام می‌آد، external_id خودش عدد تلگرامه
  if (ctype_digit($externalId)) $userId = (int)$externalId;
}

/* --- تراکنش: identities + events (و به‌روزرسانی Users.LastVisit اگر ممکن بود) --- */
$pdo->beginTransaction();
try {
  // 1) اگر از بات/تلگرام است، تلاش برای درج سریع کاربر (بدون تغییر اسکیمای Users)
  if ($provider === 'telegram' && $userId > 0) {
    // اگر ستون LastVisit داری و nullable است، این خط کار می‌کند؛ اگر خطا داد، مشکلی نیست.
    try {
      $pdo->prepare("INSERT IGNORE INTO Users (UserId, LastVisit) VALUES (?, NOW())")->execute([$userId]);
    } catch (Throwable $e) { /* بی‌صدا */ }
  }

  // 2) identities: نگاشت provider+external_id → user_id
  // اگر userId هنوز 0 است (مثلاً guest)، از همون externalId به‌صورت hash یک عدد موقتی بساز
  if ($userId <= 0) {
    $userId = unpack('J', hash('xxh3', $externalId, true))[1]; // عدد 64بیتی پایدار از رشته
    if ($userId < 0) { $userId = PHP_INT_MAX + $userId + 1; } // مثبتش کن
  }

  $stmt = $pdo->prepare("INSERT IGNORE INTO identities (user_id, provider, external_id)
                         VALUES (?, ?, ?)");
  $stmt->execute([$userId, $provider, $externalId]);

  // 3) events: ثبت رویداد
  $stmt = $pdo->prepare("INSERT INTO events
      (user_id, source, event_type, session_id, ip, ua, meta)
      VALUES (?, ?, ?, ?, INET6_ATON(?), ?, ?)");
  $stmt->execute([
    $userId,
    $source,
    $eventType,
    $sessionId,
    $ip,
    mb_substr($ua, 0, 255),
    $meta ? json_encode($meta, JSON_UNESCAPED_UNICODE) : null
  ]);

  $pdo->commit();
  echo json_encode(['ok'=>1, 'user_id'=>$userId]);
} catch (Throwable $e) {
  $pdo->rollBack();
  http_response_code(500);
  echo json_encode(['ok'=>0,'err'=>'db','msg'=>$e->getMessage()]);
}
