<?php
header('Content-Type: text/html; charset=utf-8');

date_default_timezone_set('Asia/Tehran');

require_once 'config.php';
require_once 'functions.php';
require_once __DIR__ . '/../../../LiveScore/persiantranslate.php';

// تابع گرفتن تیم‌های منتخب
function getFeaturedTeams(PDO $db): array {
    $stmt = $db->query("SELECT team_id FROM featured_teams WHERE is_active=1");
    return array_column($stmt->fetchAll(PDO::FETCH_ASSOC), 'team_id');
}

// توکن و یوزرنیم کانال (مقدار درست رو بگذار)
$botToken = '7966366083:AAHBjvp9_2M6lrtrzdSmPrXIdvwRH6mmxxM';
$channelUsername = '@Goaltiime'; // کانال مقصد

// دکمه‌های پنل
if (isset($_POST['action']) && $_POST['action'] === 'send_now') {
    $message = $_POST['message'] ?? '';
    if ($message !== '') {
        $apiUrl = "https://api.telegram.org/bot{$botToken}/sendMessage";
        file_get_contents($apiUrl . '?' . http_build_query([
            'chat_id' => $channelUsername,
            'text' => $message,
            'parse_mode' => 'HTML'
        ]));
        $flash = '✅ پیام به کانال ارسال شد.';
    }
}

// امروز میلادی
$today = date('Y-m-d');
$apiDate = str_replace('-', '', $today);
$apiUrl = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/{$apiDate}/3.30";
$json = @file_get_contents($apiUrl);
if (!$json) {
    $previewText = "❌ خطا در دریافت اطلاعات از API";
} else {
    $data = json_decode($json);
    $featuredIds = getFeaturedTeams($db);

    $lines = [];
    if (isset($data->Stages)) {
        foreach ($data->Stages as $stage) {
            if (empty($stage->Events)) continue;
            $leagueName = getleagues($stage->Snm ?? 'لیگ نامشخص');

            foreach ($stage->Events as $event) {
                $homeId = (int)($event->T1[0]->ID ?? 0);
                $awayId = (int)($event->T2[0]->ID ?? 0);

                // فقط اگر تیم منتخب است
                if (!in_array($homeId, $featuredIds, true) && !in_array($awayId, $featuredIds, true)) {
                    continue;
                }

                // ساعت بازی
                $formattedTime = '؟';
                $teh = new DateTimeZone('Asia/Tehran');
                
                if (isset($event->Esd) && $event->Esd) {
                    $esdStr = (string)$event->Esd;
                
                    if (strlen($esdStr) >= 12) {
                        $utc = new DateTimeZone('Asia/Tehran');
                        $dt  = DateTime::createFromFormat('YmdHi', substr($esdStr, 0, 12), $utc);
                        if ($dt instanceof DateTime) {
                            $formattedTime = $dt->setTimezone($teh)->format('H:i');
                            $formattedTime = convertToPersianNumbers($formattedTime);
                        }
                    }
                }

                $home = getTeamName($event->T1[0]->Nm ?? 'تیم میزبان');
                $away = getTeamName($event->T2[0]->Nm ?? 'تیم مهمان');

                // گروه‌بندی بر اساس لیگ
                if (!isset($grouped[$leagueName])) {
                    $grouped[$leagueName] = [];
                }
                $grouped[$leagueName][] = "🔹 {$home} {$formattedTime} {$away}";

            }
        }
    }

if (!empty($grouped)) {
    $todayFa = gregorianToJalaliDate($today);
    $previewText = "🔥 مهم‌ترین بازی‌های امروز ({$todayFa})\n\n";

    foreach ($grouped as $league => $matches) {
    $previewText .= "🔮  ($league)\n\n";
        foreach ($matches as $match) {
            $previewText .= "{$match}\n";
        }
        $previewText .= "\n"; // فاصله بین لیگ‌ها
    }

    // — امضا زیر پیش‌نمایش —
    $botUser    = isset($BotUserName) ? $BotUserName : '@LiveCubeFootball_bot';
    // $channelUsr = isset($channelUsername) ? $channelUsername : '@KickPrediict';

    $previewText .= "🔎 نتایج زنده و لینک‌های پخش در ربات:\n\n{$botUser}";
} else {
    $previewText = "📭 امروز بازی مهمی برای تیم‌های منتخب وجود ندارد.";
}

}

if (!function_exists('getFeaturedTeams')) {
    function getFeaturedTeams(PDO $db): array {
        $stmt = $db->query("SELECT team_id FROM featured_teams WHERE is_active=1");
        return array_column($stmt->fetchAll(PDO::FETCH_ASSOC), 'team_id');
    }
}

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>مهم‌ترین بازی‌های امروز</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css">
</head>
<body class="bg-gray-900 text-white p-4">
<div class="max-w-4xl mx-auto">
    <h1 class="text-xl font-bold mb-4">🔥 مهم‌ترین بازی‌های امروز</h1>

    <?php if (!empty($flash)): ?>
        <div class="bg-green-600 p-3 rounded mb-4"><?= htmlspecialchars($flash) ?></div>
    <?php endif; ?>

    <form method="post">
        <textarea name="message" rows="12" class="w-full p-3 text-black rounded mb-3"><?= htmlspecialchars($previewText) ?></textarea>
        <div class="flex gap-2">
            <button type="submit" name="action" value="send_now" class="bg-blue-600 px-4 py-2 rounded">📤 ارسال الان به کانال</button>
        </div>
    </form>

        <div class="mt-8 text-center">
            <a href="dashboard.php" class="text-blue-600 hover:text-blue-800 font-medium">⬅️ بازگشت به داشبورد</a>
        </div>
</div>
</body>
</html>
