<?php
declare(strict_types=1);
ini_set('display_errors','1');
error_reporting(E_ALL);
date_default_timezone_set('Asia/Tehran');

require_once 'config.php';            
require_once 'functions.php';         
require_once __DIR__ . '/../../../LiveScore/persiantranslate.php'; 


$botToken        = '7966366083:AAHBjvp9_2M6lrtrzdSmPrXIdvwRH6mmxxM';
$channelUsername = '@GoalTiime';

function vlog(string $msg): void { /* خاموش */ } // اگر خواستی دیباگ کنی، داخلش error_log($msg) بذار

try {
    $db->exec("
        CREATE TABLE IF NOT EXISTS sent_events (
            event_hash VARCHAR(64) NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (event_hash)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
    ");
} catch (Throwable $e) {
    error_log('Create table error: ' . $e->getMessage());
}

/* ===== توابع ===== */
if (!function_exists('getFeaturedTeams')) {
    function getFeaturedTeams(PDO $db): array {
        try {
            $stmt = $db->query("SELECT team_id FROM featured_teams WHERE is_active=1");
            return array_map('intval', array_column($stmt->fetchAll(PDO::FETCH_ASSOC), 'team_id'));
        } catch (Throwable $e) {
            error_log('getFeaturedTeams error: ' . $e->getMessage());
            return [];
        }
    }
}
if (!function_exists('isFinished')) {
    function isFinished(?string $eps): bool {
        return in_array($eps, ['FT','AET','PEN','FT_PEN','AP'], true);
    }
}

/* فقط بعد از ارسال موفق، ثبتِ ضدتکرار کن */
function wasSent(PDO $db, string $hash): bool {
    $stmt = $db->prepare("SELECT 1 FROM sent_events WHERE event_hash=? LIMIT 1");
    $stmt->execute([$hash]);
    return (bool)$stmt->fetchColumn();
}
function markSent(PDO $db, string $hash): void {
    try {
        $stmt = $db->prepare("INSERT IGNORE INTO sent_events (event_hash) VALUES (?)");
        $stmt->execute([$hash]);
    } catch (Throwable $e) {
        error_log("markSent error: " . $e->getMessage());
    }
}

/* ارسال به تلگرام: فقط خطاها را لاگ کن */
function sendToChannel(string $botToken, array $channelUsernames, string $text): bool {
    $api = "https://api.telegram.org/bot{$botToken}/sendMessage";
    $okAll = true;
    foreach ($channelUsernames as $channelUsername) {
        $payload = [
            'chat_id' => $channelUsername,
            'text'    => $text,
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true,
        ];
        $ctx = stream_context_create(['http'=>[
            'method'=>'POST',
            'header'=>"Content-Type: application/x-www-form-urlencoded\r\n",
            'content'=>http_build_query($payload),
            'timeout'=>15,
        ]]);
        $resp = @file_get_contents($api, false, $ctx);
        if ($resp === false) {
            $err = error_get_last();
            error_log("Telegram send failed ({$channelUsername}): " . ($err['message'] ?? 'unknown'));
            $okAll = false;
        } else {
            $j = json_decode($resp, true);
            if (!($j['ok'] ?? false)) {
                error_log("Telegram API error ({$channelUsername}): " . $resp);
                $okAll = false;
            }
        }
        usleep(200000); // rate limit
    }
    return $okAll;
}

/* ===== گرفتن فید ===== */
$nowHour = (int)date('G'); // 0..23
$today   = $nowHour < 2 ? date('Y-m-d', strtotime('-1 day')) : date('Y-m-d');
$apiDate = str_replace('-', '', $today);

$json = @file_get_contents("https://prod-public-api.livescore.com/v1/api/app/date/soccer/{$apiDate}/3.30");
if (!$json) {
    $json = @file_get_contents("https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30");
}
if (!$json) exit;

$data = json_decode($json);
if (!isset($data->Stages) || !is_array($data->Stages)) exit;

$featuredIds = getFeaturedTeams($db);

/* ===== پردازش ===== */
foreach ($data->Stages as $stage) {
    if (empty($stage->Events) || !is_array($stage->Events)) continue;

    $leagueName = getleagues($stage->Cnm ?? '') . ' / ' . getleagues($stage->Snm ?? 'لیگ نامشخص');

    foreach ($stage->Events as $event) {
        $homeId = (int)($event->T1[0]->ID ?? 0);
        $awayId = (int)($event->T2[0]->ID ?? 0);

        // فقط تیم‌های منتخب
        if (!empty($featuredIds) && !in_array($homeId,$featuredIds,true) && !in_array($awayId,$featuredIds,true)) {
            continue;
        }

        // فقط پایان‌یافته‌ها
        $eps = $event->Eps ?? null;
        if (!isFinished($eps)) continue;

        // هش بازی
        $eid  = (string)($event->Eid ?? '');
        if ($eid === '') {
            $esd = (string)($event->Esd ?? '');
            $eid = md5($homeId.'-'.$awayId.'-'.$esd.'-FT');
        }
        $hash = sha1('FT-'.$eid);

        // اگر قبلاً ارسال شده، بیخیال
        if (wasSent($db, $hash)) {
            vlog("Skip duplicate: $hash");
            continue;
        }

        // ساخت متن
        $home = getTeamName($event->T1[0]->Nm ?? 'تیم میزبان');
        $away = getTeamName($event->T2[0]->Nm ?? 'تیم مهمان');
        $g1   = convertToPersianNumbers((string)($event->Tr1 ?? '—'));
        $g2   = convertToPersianNumbers((string)($event->Tr2 ?? '—'));

        $text = "✅ پایان بازی\n\n⚽️ {$leagueName}\n\n".
                "🎯 {$home} {$g1}–{$g2} {$away}\n\n".
                "@LiveCubeFootball_bot";

        // ارسال → بعد از موفقیت، ضدتکرار را ثبت کن
        $ok = sendToChannel($botToken, [$channelUsername], $text);
        if ($ok) {
            markSent($db, $hash);
        }
        usleep(200000);
    }
}
