<?php
declare(strict_types=1);
ini_set('display_errors','1');
error_reporting(E_ALL);
date_default_timezone_set('Asia/Tehran');

require_once 'config.php';
require_once 'functions.php';
require_once __DIR__ . '/../../../LiveScore/persiantranslate.php';

$botToken        = '7966366083:AAHBjvp9_2M6lrtrzdSmPrXIdvwRH6mmxxM';
$channelUsername = '@GoalTiime';

/* --------- توابع کمکی --------- */
if (!function_exists('getFeaturedTeams')) {
    function getFeaturedTeams(PDO $db): array {
        $stmt = $db->query("SELECT team_id FROM featured_teams WHERE is_active=1");
        return array_column($stmt->fetchAll(PDO::FETCH_ASSOC), 'team_id');
    }
}
function isFinished(?string $eps): bool {
    return in_array($eps, ['FT','AET','PEN','FT_PEN','AP'], true);
}

/* --------- ساخت پیش‌نمایش نتایج امروز --------- */
// اگر هنوز قبلِ ساعت 02:00 هستیم، تاریخ را دیروز بگیر تا نتایج روز قبل حفظ شود
$nowHour = (int)date('G'); // 0..23
$today   = $nowHour < 2 ? date('Y-m-d', strtotime('-1 day')) : date('Y-m-d');
$apiDate = str_replace('-', '', $today);
$apiUrl  = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/{$apiDate}/3.30";

$previewText = "📭 امروز نتیجه‌ای برای تیم‌های منتخب یافت نشد.";
$json = @file_get_contents($apiUrl);
if ($json) {
    $data        = json_decode($json);
    $featuredIds = getFeaturedTeams($db);
    $grouped     = [];

    if (isset($data->Stages)) {
        foreach ($data->Stages as $stage) {
            if (empty($stage->Events)) continue;
            $leagueName = getleagues($stage->Snm ?? 'لیگ نامشخص');

            foreach ($stage->Events as $event) {
                $homeId = (int)($event->T1[0]->ID ?? 0);
                $awayId = (int)($event->T2[0]->ID ?? 0);
                if (!in_array($homeId,$featuredIds,true) && !in_array($awayId,$featuredIds,true)) continue;

                if (!isFinished($event->Eps ?? null)) continue;

                $home = getTeamName($event->T1[0]->Nm ?? 'تیم میزبان');
                $away = getTeamName($event->T2[0]->Nm ?? 'تیم مهمان');
                $g1   = convertToPersianNumbers((string)($event->Tr1 ?? '—'));
                $g2   = convertToPersianNumbers((string)($event->Tr2 ?? '—'));

                $grouped[$leagueName][] = "🔹 {$home} {$g1}–{$g2} {$away}";
            }
        }
    }

    if (!empty($grouped)) {
        $todayFa    = gregorianToJalaliDate($today);
        $previewText = "📋 نتایج مهمترین بازی‌های ({$todayFa})\n\n";
        foreach ($grouped as $league => $matches) {
            $leagueFa   = convertToPersianNumbers($league);
            $previewText .= "🔮 {$leagueFa}\n";
            $previewText .= implode("\n", $matches) . "\n\n";
        }
        
            $previewText .= "🔎 نتایج زنده و لینک‌های پخش در مینی اپ:\n\n@LiveCubeFootball_bot";
    }
}

/* --------- ارسال اکنون --------- */
$flash = '';
if (isset($_POST['action']) && $_POST['action'] === 'send_now') {
    $api = "https://api.telegram.org/bot{$botToken}/sendMessage";
    @file_get_contents($api.'?'.http_build_query([
        'chat_id'    => $channelUsername,
        'text'       => $previewText,   // نسخه خام برای HTML
        'parse_mode' => 'HTML'
    ]));
    $flash = '✅ پیام نتایج به کانال ارسال شد.';
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>نتایج مهمترین بازی‌های</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css">
</head>
<body class="bg-gray-900 text-white p-4">
<div class="max-w-4xl mx-auto">
  <h1 class="text-xl font-bold mb-4">📋 نتایج مهمترین بازی‌های</h1>

  <?php if ($flash): ?>
    <div class="bg-green-600 p-3 rounded mb-4"><?= htmlspecialchars($flash) ?></div>
  <?php endif; ?>

  <form method="post">
    <!-- پیش‌نمایش امن در فرم -->
    <textarea name="message" rows="14" class="w-full p-3 text-black rounded mb-3"><?= htmlspecialchars($previewText) ?></textarea>
    <button type="submit" name="action" value="send_now" class="bg-blue-600 px-4 py-2 rounded">📤 ارسال الان به کانال</button>
  </form>

  <div class="mt-4">
    <a href="dashboard.php" class="text-blue-600 hover:text-blue-800 font-medium">⬅️ بازگشت به داشبورد</a>
  </div>
</div>
</body>
</html>
