<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

require_once 'config.php';
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$bot_token = '7966366083:AAHBjvp9_2M6lrtrzdSmPrXIdvwRH6mmxxM';
$admin_id = 745398320; // آیدی خودت برای گزارش پیشرفت

$success = 0;
$fail = 0;
$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST" && !empty($_POST['text'])) {
    $text = $_POST['text'];

    try {
        $stmt = $db->query("SELECT * FROM Users ORDER BY UserId DESC");
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $counter = 0;
        $batch_size = 50;

        // بررسی اینکه آیا عکس آپلود شده یا نه
        $photo_sent = false;
        $photo_path = null;
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
            $photo_path = $_FILES['photo']['tmp_name'];
            $photo_sent = true;
        }

        foreach ($users as $user) {
            $chat_id = $user['UserId'];

            if ($photo_sent) {
                // ارسال عکس به همراه کپشن
                $url = "https://api.telegram.org/bot$bot_token/sendPhoto";
                $post_fields = [
                    'chat_id' => $chat_id,
                    'photo' => new CURLFile($photo_path),
                    'caption' => $text,
                    'parse_mode' => 'HTML'
                ];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 20);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
                $result = curl_exec($ch);
                curl_close($ch);
            } else {
                // ارسال متن ساده
                $url = "https://api.telegram.org/bot$bot_token/sendMessage";
                $payload = [
                    "chat_id" => $chat_id,
                    "text" => $text,
                    "parse_mode" => "HTML"
                ];
                file_get_contents($url . "?" . http_build_query($payload));
            }

            // شمارش موفقیت یا خطا (ساده، بدون بررسی دقیق)
            $success++;
            $counter++;

            // گزارش و توقف هر batch
            if ($counter % $batch_size === 0) {
                $progress_payload = [
                    "chat_id" => $admin_id,
                    "text" => "📊 تا الان $counter پیام ارسال شده است.\n✅ موفق: $success",
                ];
                file_get_contents("https://api.telegram.org/bot$bot_token/sendMessage?" . http_build_query($progress_payload));
                sleep(1); // توقف ۲ ثانیه‌ای
            }
        }

        // گزارش نهایی به ادمین
        $final_payload = [
            "chat_id" => $admin_id,
            "text" => "✅ ارسال همگانی به پایان رسید.\n📬 موفق: $success",
        ];
        file_get_contents("https://api.telegram.org/bot$bot_token/sendMessage?" . http_build_query($final_payload));

        $message = "✅ پیام به کل کاربران ارسال شد: $success ارسال موفق.";
    } catch (PDOException $e) {
        $message = "❌ خطا در ارتباط با دیتابیس: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ارسال پیام همگانی</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Vazirmatn', sans-serif;
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;700&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center p-4">
    <div class="bg-white rounded-2xl shadow-xl p-8 w-full max-w-md">
        <h2 class="text-2xl font-bold text-center text-gray-800 mb-6">✉️ ارسال پیام به تمام کاربران</h2>

        <?php if ($message): ?>
            <div class="bg-<?php echo strpos($message, 'موفقیت') !== false ? 'green' : 'red'; ?>-100 border border-<?php echo strpos($message, 'موفقیت') !== false ? 'green' : 'red'; ?>-400 text-<?php echo strpos($message, 'موفقیت') !== false ? 'green' : 'red'; ?>-700 px-4 py-3 rounded-lg mb-6 animate-fade-in">
                <?= htmlspecialchars($message) ?>
            </div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data" class="space-y-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">📝 متن پیام</label>
                <textarea name="text" required
                          class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200"
                          placeholder="متن پیام خود را وارد کنید" rows="6"></textarea>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">📷 انتخاب عکس (اختیاری)</label>
                <input type="file" name="photo" accept="image/*"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-200">
            </div>
        
            <button type="submit"
                    class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition duration-200 font-medium">
                ارسال
            </button>
        </form>

        <div class="mt-6 text-center">
            <a href="dashboard.php" class="text-blue-600 hover:text-blue-800 font-medium">⬅️ بازگشت به داشبورد</a>
        </div>
    </div>

    <script>
        // Simple animation for form inputs
        const textarea = document.querySelector('textarea');
        textarea.addEventListener('focus', () => {
            textarea.parentElement.classList.add('scale-105');
        });
        textarea.addEventListener('blur', () => {
            textarea.parentElement.classList.remove('scale-105');
        });
    </script>
</body>
</html>