<?php
declare(strict_types=1);
ini_set('display_errors','1'); error_reporting(E_ALL);

require_once 'config.php';
require_once 'functions.php';
require_once __DIR__ . '/../../../LiveScore/persiantranslate.php';

if (!defined('TOKEN')) define('TOKEN', '7966366083:AAHBjvp9_2M6lrtrzdSmPrXIdvwRH6mmxxM');
if (!defined('CHANNEL')) define('CHANNEL', '@Goaltiime');
define('WATERMARK_TEXT', 'LiveCube');
define('FOOTER_BOT', '@LiveCubeFootball_bot');

require_once 'top_players.php';

$SAVE_DIR = realpath(__DIR__.'/../assets') ?: (__DIR__.'/../assets');
if (!is_dir($SAVE_DIR)) @mkdir($SAVE_DIR, 0775, true);

$leagues = [
  '65' => 'پریمیرلیگ (انگلستان)',
  '75' => 'لالیگا (اسپانیا)',
  '77' => 'سری آ (ایتالیا)',
  '67' => 'بوندسلیگا (آلمان)',
  '68' => 'لیگ یک (فرانسه)',
  '403'=> 'لیگ حرفه‌ای عربستان',
  '145'=> 'ام‌ال‌اس (آمریکا)',
  // ایران: مسیر stage به‌جای آیدی عددی
  'stage:iran/pro-league/2' => 'پرشین گلف (ایران)',
  '64' => 'اردیویزه (هلند)',
  '79' => 'پریمیرا لیگا (پرتغال)',
  '692' => 'لیگ نخبگان آسیا',
  '60' => 'لیگ قهرمانان اروپا: گروهی',
  
];

$sel = $_GET['competition'] ?? $_POST['competition'] ?? '65';
if (!array_key_exists($sel, $leagues)) $sel = '65';

function fetchLeagueTable(string $sel): array {
  if (strpos($sel, 'stage:') === 0) {
    // مثال: stage:iran/pro-league/2  →  iran/pro-league/2
    $stagePath = substr($sel, 6);
    $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/stage/soccer/{$stagePath}?locale=en";
  } else {
    $id  = (string)$sel;
    $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/competition/{$id}/leagueTable/?locale=en";
  }

  $json = @file_get_contents($url);
  if (!$json) return [];
  $data = json_decode($json, true);

  // هر دو endpoint معمولاً Stages دارند
  $stage = $data['Stages'][0] ?? null;
  if (!$stage) return [];

  // نام مسابقات
  $compName = trim(($stage['Cnm'] ?? '').' / '.($stage['Snm'] ?? 'League'));

  // مسیرهای مختلف برای جدول
  $paths = [
    ['LeagueTable','L',0,'Tables',0,'team'],
    ['LeagueTable','Tables',0,'team'],
    ['LeagueTable','L',0,'team'],
    ['LeagueTable','team'],
  ];
  $teams = [];
  foreach ($paths as $path){
    $tmp = $stage;
    foreach ($path as $k){
      if (!isset($tmp[$k])) { $tmp = null; break; }
      $tmp = $tmp[$k];
    }
    if (is_array($tmp) && $tmp){ $teams = $tmp; break; }
  }
  return ['comp'=>$compName,'teams'=>$teams];
}

function resolveFontPath(): ?string {
  // استفاده مستقیم از فونت مطمئن
  $fixedFont = __DIR__ . '/../assets/fonts/Vazir-Regular.ttf';
  if (is_readable($fixedFont)) return $fixedFont;

  // اگر پیدا نشد، ادامه گزینه‌های قبلی
  $candidates = [
    __DIR__.'/../assets/fonts/Vazirmatn-Regular.ttf',
    __DIR__.'/../assets/Vazirmatn-Regular.ttf',
    '/usr/share/fonts/truetype/dejavu/DejaVuSans.ttf',
  ];
  foreach ($candidates as $p) {
    if (is_readable($p)) return $p;
  }
  $font_glob = glob(__DIR__.'/../assets/*.ttf');
  if ($font_glob) return $font_glob[0];
  return null;
}

function fixPersianText(string $text): string {
  $text = str_replace(['ـ','‍'], '', $text);
  $text = preg_replace('/[\x{200B}\x{200C}\x{200D}\x{200E}\x{200F}\x{2060}]/u', '', $text);
  $text = preg_replace('/\h+/u', ' ', trim($text));
  return $text;
}

function toPersianNumber($input): string {
  $persian = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
  $english = ['0','1','2','3','4','5','6','7','8','9'];
  return str_replace($english, $persian, strval($input));
}

function fa_shape(string $s): string {
  // حذف کشیده و فاصله‌های نامعمول
  $s = str_replace(['ـ','‍'], '', $s);

  // حروفی که اتصال بعدی ندارند (راست‌چسبان/غیرپیوندی)
$nonJoinAfter = [
  'ا','آ','أ','إ','د','ذ','ر','ز','ژ','و','ؤ','ء',
  ' ', '،', ',', '.', '-', '/', '(', ')', '«', '»', ':', '؛', '!' // جداکننده‌ها و فاصله
];

  $map = [
    'ا'=>["\u{FE8D}","\u{FE8D}","\u{FE8D}","\u{FE8E}"],
    'آ'=>["\u{FE81}","\u{FE81}","\u{FE81}","\u{FE82}"],
    'أ'=>["\u{FE83}","\u{FE83}","\u{FE83}","\u{FE84}"],
    'إ'=>["\u{FE87}","\u{FE87}","\u{FE87}","\u{FE88}"],
    'ب'=>["\u{FE8F}","\u{FE91}","\u{FE92}","\u{FE90}"],
    'پ'=>["\u{FB56}","\u{FB58}","\u{FB59}","\u{FB57}"],
    'ت'=>["\u{FE95}","\u{FE97}","\u{FE98}","\u{FE96}"],
    'ث'=>["\u{FE99}","\u{FE9B}","\u{FE9C}","\u{FE9A}"],
    'ج'=>["\u{FE9D}","\u{FE9F}","\u{FEA0}","\u{FE9E}"],
    'چ'=>["\u{FB7A}","\u{FB7C}","\u{FB7D}","\u{FB7B}"],
    'ح'=>["\u{FEA1}","\u{FEA3}","\u{FEA4}","\u{FEA2}"],
    'خ'=>["\u{FEA5}","\u{FEA7}","\u{FEA8}","\u{FEA6}"],
    'د'=>["\u{FEA9}","\u{FEA9}","\u{FEA9}","\u{FEAA}"],
    'ذ'=>["\u{FEAB}","\u{FEAB}","\u{FEAB}","\u{FEAC}"],
    'ر'=>["\u{FEAD}","\u{FEAD}","\u{FEAD}","\u{FEAE}"],
    'ز'=>["\u{FEAF}","\u{FEAF}","\u{FEAF}","\u{FEB0}"],
    'ژ'=>["\u{FB8A}","\u{FB8A}","\u{FB8A}","\u{FB8B}"],
    'س'=>["\u{FEB1}","\u{FEB3}","\u{FEB4}","\u{FEB2}"],
    'ش'=>["\u{FEB5}","\u{FEB7}","\u{FEB8}","\u{FEB6}"],
    'ص'=>["\u{FEB9}","\u{FEBB}","\u{FEBC}","\u{FEBA}"],
    'ض'=>["\u{FEBD}","\u{FEBF}","\u{FEC0}","\u{FEBE}"],
    'ط'=>["\u{FEC1}","\u{FEC3}","\u{FEC4}","\u{FEC2}"],
    'ظ'=>["\u{FEC5}","\u{FEC7}","\u{FEC8}","\u{FEC6}"],
    'ع'=>["\u{FEC9}","\u{FECB}","\u{FECC}","\u{FECA}"],
    'غ'=>["\u{FECD}","\u{FECF}","\u{FED0}","\u{FECE}"],
    'ف'=>["\u{FED1}","\u{FED3}","\u{FED4}","\u{FED2}"],
    'ق'=>["\u{FED5}","\u{FED7}","\u{FED8}","\u{FED6}"],
    'ک'=>["\u{FB8E}","\u{FB90}","\u{FB91}","\u{FB8F}"], // کاف فارسی
    'گ'=>["\u{FB92}","\u{FB94}","\u{FB95}","\u{FB93}"],
    'ك'=>["\u{FED9}","\u{FEDB}","\u{FEDC}","\u{FEDA}"], // کاف عربی
    'ل'=>["\u{FEDD}","\u{FEDF}","\u{FEE0}","\u{FEDE}"],
    'م'=>["\u{FEE1}","\u{FEE3}","\u{FEE4}","\u{FEE2}"],
    'ن'=>["\u{FEE5}","\u{FEE7}","\u{FEE8}","\u{FEE6}"],
    'ه'=>["\u{FEE9}","\u{FEEB}","\u{FEEC}","\u{FEEA}"],
    'و'=>["\u{FEED}","\u{FEED}","\u{FEED}","\u{FEEE}"],
    'ی'=>["\u{FBFC}","\u{FBFE}","\u{FBFF}","\u{FBFD}"], // ی فارسی
    'ي'=>["\u{FEF1}","\u{FEF3}","\u{FEF4}","\u{FEF2}"], // ی عربی
    'ء'=>["\u{FE80}","\u{FE80}","\u{FE80}","\u{FE80}"],
    'ئ'=>["\u{FE89}","\u{FE8B}","\u{FE8C}","\u{FE8A}"], // یِ همزه‌دار (برای رئال و امثال آن)

    '‌'=>['','', '', ''], // ZWNJ
  ];

  // Ligature Lam-Alef
  $lam = 'ل';
  $alefForms = [
    'ا'=>"\u{FEFB}", 'آ'=>"\u{FEF5}", 'أ'=>"\u{FEF7}", 'إ'=>"\u{FEF9}"
  ];

  $chars = preg_split('//u', $s, -1, PREG_SPLIT_NO_EMPTY);
  $out   = [];

  $count = count($chars);
  for ($i=0; $i<$count; $i++) {
    $c = $chars[$i];

    // Ligature: Lam + Alef
    if ($c === $lam && $i+1 < $count && isset($alefForms[$chars[$i+1]])) {
      // موقعیت قبل و بعد برای انتخاب فرم مناسب مهم نیست؛ همین گلیف ترکیبی کفایت می‌کند
      $out[] = $alefForms[$chars[$i+1]];
      $i++; // مصرف آ بعد از لام
      continue;
    }

    if (!isset($map[$c])) { $out[] = $c; continue; }

    // آیا حرف قبلی «اتصال بعد» داشته و خودش هم قابل اتصال قبل هست؟
    $prev = $out ? $chars[$i-1] : null;
    $canJoinBefore = $prev && isset($map[$prev]) && !in_array($prev, $nonJoinAfter, true);

    // آیا حرف بعدی قابل اتصال است؟
    $next = $i+1 < $count ? $chars[$i+1] : null;
    $canJoinAfter  = $next && isset($map[$next]) && !in_array($c, $nonJoinAfter, true);

    // انتخاب فرم: 0=منفصل،1=ابتدا،2=میانی،3=انتهایی
    $form = 0;
    if ($canJoinBefore && $canJoinAfter) $form = 2;       // میانی
    elseif ($canJoinBefore && !$canJoinAfter) $form = 3;  // انتهایی
    elseif (!$canJoinBefore && $canJoinAfter) $form = 1;  // ابتدایی
    else $form = 0;                                      // منفصل

    $out[] = $map[$c][$form];
  }

  return implode('', $out);
}

function mb_strrev(string $s): string {
  $out = '';
  for ($i = mb_strlen($s, 'UTF-8') - 1; $i >= 0; $i--) {
    $out .= mb_substr($s, $i, 1, 'UTF-8');
  }
  return $out;
}

function fa_bidi(string $s): string {
  $s = fa_shape($s);

  // وارونه‌سازی کل رشته
  $s = mb_strrev($s);

  // برگرداندن ترتیب «رشته‌های عدد/لاتین/نشانه‌ها» به حالت طبیعی
  $s = preg_replace_callback('/[0-9۰-۹A-Za-z@:._\-\/+]+/u', function($m){
    return mb_strrev($m[0]);
  }, $s);

  // آینه‌کردن پرانتزها پس از وارونه‌سازی
  $mir = [
    '('=>')', ')'=>'(', '«'=>'»', '»'=>'«',
    '['=>']', ']'=>'[', '{'=>'}', '}'=>'{'
  ];
  $s = strtr($s, $mir);

  return $s;
}

function fa_gd(string $s): string {
  // جداکردن فاصله‌های زائد احتمالی که از API می‌آید
  $s = preg_replace('/\h+/u', ' ', trim($s));
  return fa_bidi($s);
}

function ttf_metrics(int $size, string $font, string $text): array {
  $bb = imagettfbbox($size, 0, $font, $text);
  $width   = abs($bb[2] - $bb[0]);
  $height  = abs($bb[7] - $bb[1]); // کل ارتفاع با صعود/نزول
  $ascent  = abs($bb[7]);          // بالای baseline (عددی مثبت)
  $descent = abs($bb[1]);          // پایین baseline
  return compact('width','height','ascent','descent');
}

function draw_cell_right($img, int $xRight, int $rowTop, int $rowH, int $size, int $color, string $font, string $text): void {
  $m = ttf_metrics($size, $font, $text);
  // baseline دقیقا وسط ردیف
  $baselineY = (int) round($rowTop + ($rowH + $m['height'])/2 - $m['descent']);
  $x = $xRight - $m['width'];
  imagettftext($img, $size, 0, $x, $baselineY, $color, $font, $text);
}

function fa_keep_halfspace(string $s): string {
  // ZWNJ → THIN SPACE  (U+200C → U+2009)
  return str_replace("\u{200C}", "\u{2009}", $s);
}

function render_table_image_gd(string $title, array $teams, string $fontPath, string $savePath): bool {
  if (!function_exists('imagettftext')) return false;
  if (!is_readable($fontPath)) return false;

  // Layout
  $w = 1000;
  $marginX = 30;
  $marginY = 30;
  $rowH   = 44;
  $titleH = 78;
  $headerH= 50;
  $footerH = 72; // ارتفاع فوتر

  // Height
  $rows = max(1, count($teams));
  $h = $marginY * 2 + $titleH + $headerH + ($rows * $rowH) + $footerH;
  if ($h < 300) $h = 300;

  // Canvas
  $img = imagecreatetruecolor($w, $h);
  $bg = imagecolorallocate($img, 11, 15, 22);
  imagefilledrectangle($img, 0, 0, $w, $h, $bg);

  // Colors
  $white    = imagecolorallocate($img, 232, 238, 247);
  $muted    = imagecolorallocate($img, 170, 181, 198);
  $green    = imagecolorallocate($img, 76, 175, 80);
  $headerBg = imagecolorallocatealpha($img, 255, 255, 255, 115);
  imagealphablending($img, true);
  imagesavealpha($img, true);
  // زیرلایه واترمارک خیلی محو (قبل از هر متن دیگری)
$wmText  = defined('WATERMARK_TEXT') ? WATERMARK_TEXT : 'LiveCube';
$wmAlpha = 120; // 0=کاملاً مات، 127=کاملاً شفاف (عدد بالا=محوتر)
$wmColor = imagecolorallocatealpha($img, 255, 255, 255, $wmAlpha);
$wmSize  = 22;
$wmAngle = 30;   // درجه
$stepX   = 260;  // فاصله افقی تکرار
$stepY   = 180;  // فاصله عمودی تکرار

for ($yy = -60; $yy < $h; $yy += $stepY) {
  for ($xx = -120; $xx < $w; $xx += $stepX) {
    imagettftext($img, $wmSize, $wmAngle, $xx, $yy, $wmColor, $fontPath, $wmText);
  }
}

  $rowEvenBg = imagecolorallocatealpha($img, 255, 255, 255, 118);
  $grid      = imagecolorallocatealpha($img, 255, 255, 255, 90);

  $rtlMark = "\xE2\x80\x8F";

  // --- Title (two lines)
//   $line1 = 'LiveCube';
  $titleClean = fa_norm($title);
  $line2      = fa_gd($titleClean); // اگر ترجیح دادی فقط shape: $rtlMark.fa_shape($titleClean)

  $yTitle1 = $marginY + 24;
//   imagettftext($img, 24, 0, $marginX, $yTitle1, $white, $fontPath, $line1);

  $lineGap   = 20;
  $yTitle2   = $yTitle1 + $lineGap;
  $bbox2     = imagettfbbox(24, 0, $fontPath, $line2);
  $line2W    = $bbox2[2] - $bbox2[0];
  imagettftext($img, 24, 0, $w - $marginX - $line2W, $yTitle2, $white, $fontPath, $line2);

  $y = $marginY + $titleH;

  // --- Header bar
  imagefilledrectangle($img, $marginX, $y, $w - $marginX, $y + $headerH, $headerBg);

  // Column x (right edges)
  $x_rank = $w - $marginX - 20;
  $x_team = $w - $marginX - 190;
  $x_pld  = $w - $marginX - 430;
  $x_win  = $w - $marginX - 520;
  $x_draw = $w - $marginX - 610;
  $x_loss = $w - $marginX - 700;
  $x_pts  = $w - $marginX - 790;

  // Header labels (centered vertically)
  $headerSize = 16;
  $headerTop  = $y;
  draw_cell_right($img, $x_rank, $headerTop, $headerH, $headerSize, $white, $fontPath, fa_gd("رده"));
  draw_cell_right($img, $x_team, $headerTop, $headerH, $headerSize, $white, $fontPath, fa_gd("تیم"));
  draw_cell_right($img, $x_pld,  $headerTop, $headerH, $headerSize, $white, $fontPath, fa_gd("بازی"));
  draw_cell_right($img, $x_win,  $headerTop, $headerH, $headerSize, $white, $fontPath, fa_gd("برد"));
  draw_cell_right($img, $x_draw, $headerTop, $headerH, $headerSize, $white, $fontPath, fa_gd("مساوی"));
  draw_cell_right($img, $x_loss, $headerTop, $headerH, $headerSize, $white, $fontPath, fa_gd("باخت"));
  draw_cell_right($img, $x_pts,  $headerTop, $headerH, $headerSize, $white, $fontPath, fa_gd("امتیاز"));

  $yRowsStart = $y + $headerH;

  // --- Rows
  $rowSize = 18;
  $rank    = 1;
  for ($i=0; $i<count($teams); $i++) {
    $t = $teams[$i];
    $rowTop = $yRowsStart + $i*$rowH;

    if ($i % 2 === 0) {
      imagefilledrectangle($img, $marginX, $rowTop, $w - $marginX, $rowTop + $rowH, $rowEvenBg);
    }
    imageline($img, $marginX, $rowTop, $w - $marginX, $rowTop, $grid);

    $rnk = toPersianNumber($t['rnk'] ?? $t['rank'] ?? $rank);
    $teamRaw = $t['Tnm'] ?? $t['teamName'] ?? 'Team';
    $team    = fa_norm(fixPersianText(getTeamName($teamRaw)));
    $pld = toPersianNumber($t['pld'] ?? $t['Pl'] ?? 0);
    $w_  = toPersianNumber($t['win'] ?? $t['W'] ?? 0);
    $d   = toPersianNumber($t['drw'] ?? $t['D'] ?? 0);
    $l   = toPersianNumber($t['lst'] ?? $t['L'] ?? 0);
    $pts = toPersianNumber($t['pts'] ?? $t['Pts'] ?? 0);

    draw_cell_right($img, $x_rank, $rowTop, $rowH, $rowSize,   $muted, $fontPath, $rnk);
    draw_cell_right($img, $x_team, $rowTop, $rowH, $rowSize,   $white, $fontPath, fa_gd($team));
    draw_cell_right($img, $x_pld,  $rowTop, $rowH, $rowSize,   $muted, $fontPath, $pld);
    draw_cell_right($img, $x_win,  $rowTop, $rowH, $rowSize,   $muted, $fontPath, $w_);
    draw_cell_right($img, $x_draw, $rowTop, $rowH, $rowSize,   $muted, $fontPath, $d);
    draw_cell_right($img, $x_loss, $rowTop, $rowH, $rowSize,   $muted, $fontPath, $l);
    draw_cell_right($img, $x_pts,  $rowTop, $rowH, $rowSize+2, $green, $fontPath, $pts);

    $rank++;
  }

  // bottom line
  $lastBottom = $yRowsStart + count($teams)*$rowH;
  imageline($img, $marginX, $lastBottom, $w - $marginX, $lastBottom, $grid);
// فوتر: دو خط مرکزچین
$footerTop   = $lastBottom + 18;
$footer1 = fa_gd(fa_keep_halfspace('اولین مینی‌اپ و ربات نتایج زنده در تلگرام'));
$footer2     = defined('FOOTER_BOT') ? FOOTER_BOT : '@LiveCubeFootball_bot';

// تابع کوچک برای مرکزچین کردن متن
$centerText = function($size, $y, $color, $text) use ($img, $fontPath, $w) {
  $bb = imagettfbbox($size, 0, $fontPath, $text);
  $tw = $bb[2] - $bb[0];
  $x  = (int) round(($w - $tw) / 2);
  imagettftext($img, $size, 0, $x, $y, $color, $fontPath, $text);
};

// خط اول (متن توضیحی)
$centerText(16, $footerTop + 16, $muted, $footer1);

// خط دوم (آدرس ربات) — کمی برجسته‌تر
$centerText(18, $footerTop + 16 + 26, $white, $footer2);

  // Crop
  $finalHeight = $lastBottom + $footerH; // فوتر هم حساب شود
  $croppedImg  = imagecreatetruecolor($w, $finalHeight);
  imagecopy($croppedImg, $img, 0, 0, 0, 0, $w, $finalHeight);
  imagedestroy($img);

  imagepng($croppedImg, $savePath);
  imagedestroy($croppedImg);

  return is_file($savePath) && filesize($savePath) > 0;
}

function tg_sendPhoto(string $chatId, string $imagePath, string $caption=''): bool {
  $url = "https://api.telegram.org/bot".TOKEN."/sendPhoto";

  // تعیین MIME به‌صورت امن
  $mime = 'image/png';
  if (function_exists('mime_content_type')) {
      $detected = @mime_content_type($imagePath);
      if (!empty($detected)) $mime = $detected;
  }

  $post = [
    'chat_id'    => $chatId,
    'caption'    => $caption,
    'parse_mode' => 'HTML',
    'photo'      => new CURLFile($imagePath, $mime, basename($imagePath)),
  ];

  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => $post,
    CURLOPT_TIMEOUT        => 30
  ]);
  $res = curl_exec($ch);
  if ($res === false) {
    error_log('cURL error: '.curl_error($ch));
    curl_close($ch);
    return false;
  }

  $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  $j = json_decode($res, true);
  if ($http !== 200 || empty($j['ok'])) {
    error_log("Telegram API error (HTTP $http): $res");
    return false;
  }
  return true;
}

function fa_norm(string $s): string {
  // حذف نویسه‌های مزاحم اتصال
$s = str_replace("\u{200C}", ' ', $s); // ZWNJ → space
$s = str_replace(["\u{200B}", "​", "‍", "ـ"], '', $s);
  $s = strtr($s, [
    'ك' => 'ک',
    'ي' => 'ی',
    'ى' => 'ی',
    'ة' => 'ه',
    'ۀ' => 'ه',
    'إ' => 'ا',
    'أ' => 'ا',
    'ٱ' => 'ا',
  ]);

  // تثبیت فاصلهٔ معمولی
  $s = preg_replace('/\h+/u', ' ', trim($s));
  return $s;
}

$data = fetchLeagueTable($sel);
$compTitle = $leagues[$sel] ?? ($data['comp'] ?? 'لیگ');
$teams     = $data['teams'] ?? [];
$msg = '';

if (isset($_POST['send'])) {
  if (empty($teams)) {
    $msg = '❌ جدول در دسترس نیست.';
  } else {
    $safeId = str_replace(['stage:','/'], ['stage_','-'], $sel);
    $png = $SAVE_DIR.'/standings_'.$safeId.'_'.date('Ymd_His').'.png';

    $ok = false;

    // First, try GD as it's more direct for text-based tables
    $fontPath = resolveFontPath();
    if ($fontPath) {
      $ok = render_table_image_gd($compTitle, $teams, $fontPath, $png);
      if (!$ok) {
        error_log("GD failed to create image. Font path: $fontPath");
      }
    } else {
      error_log("No suitable font file found for GD rendering.");
    }
    
    // If GD failed, try the headless browser method as a fallback
    if (!$ok && function_exists('shell_exec') && find_binary(['google-chrome','chromium-browser'])) {
      $html = build_html($compTitle, $teams);
      $ok = html_to_png($html, $png);
      if (!$ok) {
        error_log("Headless browser failed to create image.");
      }
    }

    if ($ok) {

$capTitle = '📇 ' . fa_norm($compTitle);

$top   = array_slice($teams, 0, 6);
$lines = [];
$rank  = 1;

foreach ($top as $t) {
    $teamRaw = $t['Tnm'] ?? $t['teamName'] ?? 'Team';
    $team    = fa_norm(fixPersianText(getTeamName($teamRaw)));
    $ptsVal  = (int)($t['pts'] ?? $t['Pts'] ?? $t['pt'] ?? 0);

    $lines[] = toPersianNumber($rank) . '. ' . $team . ': ' . toPersianNumber($ptsVal) . ' امتیاز';
    $rank++;
}

$ctas = [
    "👈🏻  تمام جداول در مینی\u{200C}اپ نتایج زنده فوتبال:\n@LiveCubeFootball_bot",
    "👈🏻  پیش\u{200C}بینی رایگان همراه با جایزه:\n@KickPredict_bot",
    "👈🏻  گل\u{200C}ها و آمار بازی\u{200C}ها در:\n@Goaltiime",
];

// ——— چسباندن همه بخش‌ها (نسخه تمیز و یک‌مرحله‌ای) ———
$capTitle = '📇 ' . fa_norm($compTitle);

$top   = array_slice($teams, 0, 6);
$lines = [];
$rank  = 1;
foreach ($top as $t) {
    $teamRaw = $t['Tnm'] ?? $t['teamName'] ?? 'Team';
    $team    = fa_norm(fixPersianText(getTeamName($teamRaw)));
    $ptsVal  = (int)($t['pts'] ?? $t['Pts'] ?? $t['pt'] ?? 0);
    $lines[] = toPersianNumber($rank) . '. ' . $team . ': ' . toPersianNumber($ptsVal) . ' امتیاز';
    $rank++;
}

$ctas = [
    "👈🏻  تمام جداول در مینی\u{200C}اپ نتایج زنده فوتبال:\n@LiveCubeFootball_bot",
    "👈🏻  پیش\u{200C}بینی رایگان همراه با جایزه:\n@KickPredict_bot",
    "👈🏻  گل\u{200C}ها و آمار بازی\u{200C}ها در:\n@Goaltiime",
];

// گرفتن متن برترین‌ها فقط یک‌بار
$topCaption = (function_exists('getTopPlayersCaption')) ? getTopPlayersCaption($sel) : '';
$topCaptionSafe = (is_string($topCaption) && $topCaption !== '') ? trim($topCaption) : '';

// ساخت نهایی کپشن
$cap = $capTitle . "\n\n"
     . implode("\n", $lines)
     . ($topCaptionSafe !== '' ? "\n\n".$topCaptionSafe : '')
     . "\n\n" . implode("\n\n", $ctas);

// محدودیت کپشن عکس در تلگرام ≈ 1024 کاراکتر
if (mb_strlen($cap, 'UTF-8') > 1024) {
    $cap = mb_substr($cap, 0, 1010, 'UTF-8') . "…";
}

      $sent = tg_sendPhoto(CHANNEL, $png, $cap);
      $msg  = $sent ? '✅ تصویر جدول به کانال ارسال شد.' : '❌ خطا در ارسال تصویر.';
      // Optional: Delete the temporary file after sending
      // @unlink($png);
    } else if (!$msg) {
      $msg = '❌ نتوانستم تصویر بسازم. بررسی کنید که GD با FreeType یا یک مرورگر headless (مثل Chrome) در دسترس باشد.';
    }
  }
}

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>ارسال جدول لیگ‌ها (تصویر)</title>
<script src="https://cdn.tailwindcss.com"></script>
<style>
:root{ --border:rgba(255,255,255,.12); --muted:#aab5c6; }
body{ margin:0; padding:16px; min-height:100vh; background:#0b0f16; color:#e8eef7; font-family: system-ui, -apple-system, "Segoe UI", Roboto, "Vazirmatn", sans-serif;}
.container{max-width:900px;margin:0 auto}
.card{ background:linear-gradient(180deg, rgba(255,255,255,.05), rgba(255,255,255,.03)); border:1px solid var(--border); border-radius:10px; padding:16px; }
.btn{ background:#4CAF50; color:#fff; padding:.55rem .9rem; border-radius:8px; text-decoration:none; display:inline-block }
.select{ background:#0f1723; border:1px solid var(--border); color:#e8eef7; border-radius:8px; padding:.55rem 1rem }
</style>
</head>
<body>
<div class="container">
  <div class="card" style="display:flex;align-items:center;justify-content:space-between;">
    <h1 class="text-xl md:text-2xl font-bold">ارسال جدول لیگ‌ها (تصویر)</h1>
    <!--<a href="index.html" class="btn">بازگشت</a>-->
  </div>

  <div class="card" style="margin-top:14px">
    <form method="GET" class="flex items-center gap-3">
      <select name="competition" class="select" onchange="this.form.submit()">
        <?php foreach ($leagues as $id => $name): 
              $idStr = (string)$id; ?>
          <option value="<?php echo htmlspecialchars($idStr); ?>" 
                  <?php echo ($idStr === (string)$sel ? 'selected' : ''); ?>>
            <?php echo htmlspecialchars($name); ?>
          </option>
        <?php endforeach; ?>

      </select>
      <div class="text-sm text-[var(--muted)]">ارسال به: <b><?php echo htmlspecialchars(CHANNEL); ?></b></div>
    </form>
  </div>

  <form method="POST" class="card" style="margin-top:14px">
    <input type="hidden" name="competition" value="<?php echo htmlspecialchars((string)$sel); ?>">
    <button type="submit" name="send" value="1" class="btn">ساخت تصویر و ارسال</button>
    <?php if (!empty($msg)): ?>
      <div class="mt-3 text-sm <?php echo (strpos($msg,'✅')===0?'text-green-400':'text-red-400'); ?>"><?php echo htmlspecialchars($msg); ?></div>
    <?php endif; ?>
  </form>
          <div class="mt-8 text-center">
            <a href="dashboard.php" class="text-blue-600 hover:text-blue-800 font-medium">⬅️ بازگشت به داشبورد</a>
        </div>
</div>
</body>
</html>