<?php

function getRedirectedUrlFromMeta($url, $fetchContent = false) {
    // Initialize cURL session
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false); // Do not follow HTTP redirects
    curl_setopt($ch, CURLOPT_HEADER, true); // Include headers in the output
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $redirectUrl = null;

    if (curl_errno($ch)) {
        echo "Curl error: " . curl_error($ch) . "\n";
        curl_close($ch);
        return false;
    }

    // Handle HTTP-level redirections
    if ($statusCode >= 300 && $statusCode < 400) {
        $headers = explode("\r\n", $response);
        foreach ($headers as $header) {
            if (stripos($header, 'Location:') === 0) {
                $redirectUrl = trim(substr($header, 9));
                echo "... HTTP Redirected to: $redirectUrl\n";
                return $redirectUrl;
            }
        }
    }

    curl_close($ch);

    // Handle Meta refresh-based redirects
    if (!$fetchContent && $response) {
        $dom = new DOMDocument();
        @$dom->loadHTML($response);
        $metaTags = $dom->getElementsByTagName('meta');

        foreach ($metaTags as $meta) {
            if (strtolower($meta->getAttribute('http-equiv')) == 'refresh') {
                $content = $meta->getAttribute('content');
                if (preg_match('/url=(.*)/i', $content, $matches)) {
                    $redirectUrl = html_entity_decode($matches[1]);
                    echo "... Meta Redirected to: $redirectUrl\n";
                    return trim($redirectUrl);
                }
            }
        }
    }

    return $fetchContent ? $response : $url;
}

// Example Usage
$url = "https://parseek.com/u/6222826";
$redirectedUrl = getRedirectedUrlFromMeta($url);
echo "Final URL: $redirectedUrl\n";
