<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// اگر لاگین نیست، بفرست به صفحه ورود
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: LiveMrMD/admin_English/login.php");
    exit;
}

require_once 'config.php';

// $stmt = $db->query("SELECT COUNT(*) FROM support_tickets WHERE is_answered = 0");
// $new_tickets = $stmt->fetchColumn();
$new_tickets = 0;

?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>داشبورد ادمین</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: '#1e40af',
                        secondary: '#1e3a8a',
                    }
                }
            }
        }
    </script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/vazirmatn@33.0.3/Vazirmatn-font-face.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Vazirmatn', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }
    </style>
</head>
<body class="bg-gray-100 dark:bg-gray-900 transition-colors duration-300">
    <div class="min-h-screen flex flex-col">
        <!-- Header -->
        <header class="bg-primary text-white p-4 shadow-lg">
            <div class="container mx-auto flex justify-between items-center">
                <h1 class="text-2xl font-bold flex items-center gap-2">
                    <i class="fas fa-tachometer-alt"></i> داشبورد مدیریت ربات
                </h1>
                <button onclick="toggleDarkMode()" class="p-2 rounded-full hover:bg-blue-700 transition">
                    <i class="fas fa-moon"></i>
                </button>
            </div>
        </header>

        <!-- Main Content -->
        <main class="container mx-auto p-6 flex-grow">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <a href="users.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-users text-primary text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">لیست کاربران</span>
                    </div>
                </a>
                <a href="send_message.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-bullhorn text-yellow-400 text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">ارسال پیام همگانی</span>
                    </div>
                </a>
                <a href="stats.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-chart-bar text-green-400 text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">آمار کلی</span>
                    </div>
                </a>
                <a href="featured_teams.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-star text-pink-500 text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">تیم‌های منتخب</span>
                    </div>
                </a>
                <a href="featured_today.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-star-of-life text-orange-400 text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">مهمترین بازی های امروز</span>
                    </div>
                </a>
                <a href="results_today.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-list-ol text-teal-400 text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">نتایج بازی های امروز</span>
                    </div>
                </a>
                <a href="standings_admin.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-chart-bar text-primary text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">ارسال جدول لیگ ها</span>
                    </div>
                </a>
                <a href="top_players.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fa fa-star text-red text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">ارسال بهترین های لیگ ها</span>
                    </div>
                </a>
                <a href="support.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1 relative">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-ticket-alt text-purple-500 text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">تیکت‌های پشتیبانی</span>
                        <?php if ($new_tickets > 0): ?>
                            <span class="absolute -top-2 -left-2 bg-red-500 text-white text-xs font-bold rounded-full h-6 w-6 flex items-center justify-center">
                                <?= $new_tickets ?>
                            </span>
                        <?php endif; ?>
                    </div>
                </a>
                <a href="logout.php" class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md hover:shadow-xl transition transform hover:-translate-y-1">
                    <div class="flex items-center gap-4">
                        <i class="fas fa-sign-out-alt text-primary text-2xl"></i>
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">خروج</span>
                    </div>
                </a>
            </div>
        </main>

        <!-- Footer -->
        <footer class="bg-gray-200 dark:bg-gray-800 p-4 text-center text-gray-600 dark:text-gray-400">
            <p>© 2025 داشبورد مدیریت ربات - تمام حقوق محفوظ است</p>
        </footer>
    </div>

    <script>
        function toggleDarkMode() {
            document.documentElement.classList.toggle('dark');
            localStorage.setItem('theme', document.documentElement.classList.contains('dark') ? 'dark' : 'light');
        }

        // Load theme preference
        if (localStorage.getItem('theme') === 'dark' || 
            (!localStorage.getItem('theme') && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        }
    </script>
</body>
</html>