<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

require_once 'config.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $ticket_id = $_POST['ticket_id'];
    $user_id = $_POST['user_id'];
    $answer = $_POST['answer'];

    // ذخیره پاسخ در دیتابیس
    $stmt = $db->prepare("
        UPDATE support_tickets 
        SET answer = ?, answered_at = NOW(), is_answered = 1 
        WHERE id = ?
    ");
    $stmt->execute([$answer, $ticket_id]);

    // ارسال پاسخ به کاربر از طریق ربات
    $text = "📬 پاسخ پشتیبانی:\n\n" . $answer;
    $send_url = "https://api.telegram.org/bot{$bot_token}/sendMessage?chat_id={$user_id}&text=" . urlencode($text) . "&parse_mode=HTML";
    file_get_contents($send_url);

    $_SESSION['success_message'] = "✅ پاسخ با موفقیت ارسال شد.";
    
    // هدایت به صفحه پشتیبانی
    header("Location: support.php");
    exit;
}
