<?php
echo "<pre>=== PHP Connection Test ===\n";

echo "PHP version: " . PHP_VERSION . "\n";
echo "allow_url_fopen: " . (ini_get('allow_url_fopen') ? 'On' : 'Off') . "\n";

$stream = @fsockopen("api.telegram.org", 443, $errno, $errstr, 5);
echo $stream ? "✅ Telegram reachable\n" : "❌ Telegram unreachable: $errstr ($errno)\n";

$stream2 = @fsockopen("prod-public-api.livescore.com", 443, $errno2, $errstr2, 5);
echo $stream2 ? "✅ LiveScore reachable\n" : "❌ LiveScore unreachable: $errstr2 ($errno2)\n";

echo "\nTesting file_get_contents:\n";
$json = @file_get_contents("https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30");
echo $json ? "✅ file_get_contents works!\n" : "❌ file_get_contents failed!\n";

echo "\nTesting cURL:\n";
$ch = curl_init("https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30");
curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 5]);
$res = curl_exec($ch);
echo ($res !== false) ? "✅ cURL works!\n" : "❌ cURL failed: " . curl_error($ch) . "\n";
curl_close($ch);

echo "</pre>";
