<?php
declare(strict_types=1);
ini_set('display_errors','1'); error_reporting(E_ALL);

// 🧩 تنظیمات
require_once 'config.php';

function getToken() {
    return '7966366083:AAHBjvp9_2M6lrtrzdSmPrXIdvwRH6mmxxM';
}

// 🗂 مسیر فایل ذخیره‌سازی وضعیت اعضا
define('MEMBERS_FILE', __DIR__ . '/members.json');

// 🧩 دریافت لیست اعضا
function getMembersList() {
    if (!file_exists(MEMBERS_FILE)) return [];
    $json = file_get_contents(MEMBERS_FILE);
    return json_decode($json, true) ?: [];
}

// 💾 ذخیره لیست اعضا
function saveMembersList($members) {
    file_put_contents(MEMBERS_FILE, json_encode($members, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

function bot($method, $data = []) {
    $url = "https://api.telegram.org/bot".TOKEN."/".$method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    $res = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log("cURL error: " . curl_error($ch));
    }
    curl_close($ch);
    return $res;
}

function sendMessage($chatId, $text, $replyMarkup = null) {
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($replyMarkup) $data['reply_markup'] = $replyMarkup;
    bot('sendMessage', $data);
}

function sendAnimation($chat_id, $animation, $caption = '', $reply_markup_json = null) {
    $token = (function_exists('getToken') ? getToken() : getenv('TELEGRAM_BOT_TOKEN'));

    $url = "https://api.telegram.org/bot{$token}/sendAnimation";

    $data = [
        'chat_id' => $chat_id,
        'animation' => $animation,    // می‌تونه URL عمومی، file_id یا CURLFile باشه
        'caption' => $caption,
        'parse_mode' => 'HTML',
        'disable_notification' => true,
    ];
    if (!empty($reply_markup_json)) {
        // چون کیبوردت از قبل json_encode شده، همون رشته رو بذار
        $data['reply_markup'] = $reply_markup_json;
    }

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => $data,
    ]);
$res = curl_exec($ch);
curl_close($ch);
return $res;
}

function editMessageText($chatId, $messageId, $text, $replyMarkup = null) {
    $data = [
        'chat_id' => $chatId,
        'message_id' => $messageId,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($replyMarkup) $data['reply_markup'] = $replyMarkup;
    bot('editMessageText', $data);
}

function isUserMember($userId, $channelUsername) {
    $url = "https://api.telegram.org/bot".TOKEN."/getChatMember";
    $params = [
        'chat_id' => $channelUsername,
        'user_id' => $userId
    ];
    $response = file_get_contents($url . '?' . http_build_query($params));
    $data = json_decode($response, true);

    if (!isset($data['ok']) || !$data['ok']) {
        return false;
    }

    $status = $data['result']['status'] ?? '';
    // accepted statuses: member, administrator, creator
    return in_array($status, ['member', 'administrator', 'creator']);
}

// 📩 دریافت آپدیت از تلگرام
$update = json_decode(file_get_contents("php://input"), true);

// پیام معمولی
$message = $update['message'] ?? null;
$text = $message['text'] ?? '';
$chatId = $message['chat']['id'] ?? null;

// کال‌بک‌ها (دکمه‌ها)
$callback_query = $update['callback_query'] ?? null;
$data = $callback_query['data'] ?? '';
$callbackId = $callback_query['id'] ?? null;
$messageId = $callback_query['message']['message_id'] ?? null;

if (isset($callback_query['message']['chat']['id'])) {
    $chatId = $callback_query['message']['chat']['id'];
}

// 🔹 برای تست
if (!empty($data)) {
    error_log("⚡ Callback pressed: " . $data);
}

// 🔹 فقط وقتی کاربر /start زد
if ($text == '/start') {
    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '⚽️ ورود به مینی‌اپ نتایج زنده فوتبال', 'web_app' => ['url' => 'https://www.livefootball.space/LiveScore/index.php']]],
            // [['text' => '🎯 ورود به ربات پیش‌بینی فوتبال', 'url' => 'https://t.me/KickPredict_bot']],
            [['text' => '📺 لینک پخش زنده بازی ها', 'callback_data'=>"LG"]]
        ]
    ], JSON_UNESCAPED_UNICODE);

$welcome = "سلام 🤝 به مینی‌اپ فوتبالی لایوکیوب خوش اومدی!\n\nبرای بروزرسانی ربات همیشه استارت مجدد کنید. ⬇️\n/start";

$gifUrl = 'https://www.livefootball.space/LiveScore/assets/welcome.mp4';

$localFile = new CURLFile(__DIR__ . '/assets/welcome.mp4', 'video/mp4', 'welcome.mp4');
sendAnimation($chatId, $localFile, $welcome, $keyboard);
}

elseif($data == "LG"){
    bot('answerCallbackQuery',[
        'callback_query_id'=>$callbackId,
        'text'=> "Please wait...",
        'show_alert' => false
    ]);
    
        // اول بررسی کن که کاربر واقعاً عضو کانال هست یا نه
    $channelUsername = "@Goaltiime";
    $isMember = isUserMember($chatId, $channelUsername);
    error_log("🧩 isMember: " . ($isMember ? 'true' : 'false'));
    
    $members = getMembersList();
    if ($isMember) {
        // کاربر قبلاً عضو بوده → مستقیم بفرست به لینک‌ها
        $OptionsKeyboard = [
            [['text'=>"🌐 پخش زنده بین‌المللی ۱",'url'=>"https://gr.league.do/index?sport=Football"]],
            [['text'=>"🌐 پخش زنده بین‌المللی ۲",'url'=>"https://www.matches-today.com/"]],
            [['text'=>"🌐 پخش زنده داخلی ۱",'url'=>"https://www.anten.ir/"]],
            [['text'=>"🌐 پخش زنده داخلی ۲",'url'=>"https://football360.ir/live/section"]],

            [['text'=>"⬅️ بازگشت به منو",'callback_data'=>"LiveScore"]],
        ];

        $button_select_lan = json_encode([
            'resize_keyboard'=>true,
            'inline_keyboard'=>$OptionsKeyboard
        ]);

return sendMessage($chatId,
    "<b>🌐 لینک‌های پخش زنده بازی‌های روز</b>\n\n" .
    "<b>🔗 استریم‌های در دسترس:</b>\n\n" .
    "🎥 لینک مورد نظر خود را انتخاب کنید و لذت ببرید.",
    $button_select_lan
);

    }
    
    // Step 1: Ask to join channel
    $joinKeyboard = json_encode([
        'inline_keyboard' => [
            [['text' => "📢 عضویت در کانال", 'url' => "https://t.me/Goaltiime"]],
            [['text' => "✅ بررسی عضویت", 'callback_data' => "LG_CHECK"]],
            ]
    ]);
    
    return sendMessage($chatId, 
        "⚠️ *عضویت در کانال الزامی است*\n\n" .
        "برای دسترسی به لینک‌های پخش زنده، لطفاً ابتدا در کانال ما عضو شوید:\n" .
        "🔗 @Goaltiime\n\n" .
        "بعد از عضویت، روی دکمه‌ی '✅ بررسی عضویت' کلیک کنید.",
        $joinKeyboard
    );
}

// Add this new callback for checking membership
elseif($data == "LG_CHECK"){
    bot('answerCallbackQuery',[
        'callback_query_id'=>$callbackId,
        'text'=> "Checking membership...",
        'show_alert' => false
    ]);
    
    // Check if user is member of channel
    $channelUsername = "@Goaltiime";
    $isMember = isUserMember($chatId, $channelUsername);
    error_log("🧩 isMember: " . ($isMember ? 'true' : 'false'));

    
    if(!$isMember) {
        bot('answerCallbackQuery',[
            'callback_query_id'=>$callbackId,
            'text'=> "❌ You haven't joined the channel yet!",
            'show_alert' => true
        ]);
        
        $joinKeyboard = json_encode([
            'inline_keyboard' => [
                [['text' => "📢  عضویت در کانال", 'url' => "https://t.me/GoalTiime"]],
                [['text' => "✅  بررسی عضویت", 'callback_data' => "LG_CHECK"]]
            ]
        ]);
        
        return sendMessage($chatId, 
            "❌ *عضویت تأیید نشد*\n\n" .
            "شما هنوز در کانال ما عضو نشده‌اید!\n" .
            "🔗 @Goaltiime\n\n" .
            "لطفاً ابتدا عضو شوید، سپس روی دکمه‌ی '✅ بررسی مجدد' کلیک کنید.",
            $joinKeyboard
        );
    }
    
    // User is member, show streams
    $OptionsKeyboard = [
        [['text'=>"🌐 پخش زنده بین‌المللی ۱",'url'=>"https://gr.league.do/index?sport=Football"]],
        [['text'=>"🌐 پخش زنده بین‌المللی ۲",'url'=>"https://www.matches-today.com/"]],
        [['text'=>"🌐 پخش زنده داخلی ۱",'url'=>"https://www.anten.ir/"]],
        [['text'=>"🌐 پخش زنده داخلی ۲",'url'=>"https://football360.ir/live/section"]],
        
        [['text'=>"⬅️ بازگشت به منو",'callback_data'=>"LiveScore"]],
        
        ];

    $button_select_lan = json_encode([
        'resize_keyboard'=>true,
        'inline_keyboard'=>$OptionsKeyboard
    ]);
    
    // ✅ ذخیره وضعیت عضو شدن کاربر
    $members = getMembersList();
    $members[$chatId] = true;
    saveMembersList($members);
    
    bot('answerCallbackQuery',[
        'callback_query_id'=>$callbackId,
        'text'=> "✅ دسترسی تأیید شد! از تماشای پخش زنده لذت ببر.",
        'show_alert' => false
    ]);
    
    return sendMessage($chatId,
    "<b>🌐 لینک‌های پخش زنده بازی‌های روز</b>\n\n" .
    "<b>🔗 استریم‌های در دسترس:</b>\n\n" .
    "💡 <b>از اینکه عضو کانال ما شدی ممنونیم!</b>\n" .
    "🎥 لینک مورد نظر خود را اننخاب کنید و لذت ببرید.",
        $button_select_lan
    );
}
// 🔙 بازگشت به منوی اصلی
elseif($data == "LiveScore") {
    bot('answerCallbackQuery', [
        'callback_query_id' => $callbackId,
        'text' => "بازگشت به منوی اصلی...",
        'show_alert' => false
    ]);

    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '⚽️ ورود به مینی‌اپ نتایج زنده فوتبال', 'web_app' => ['url' => 'https://www.livefootball.space/LiveScore/index.php']]],
            [['text' => '📺 لینک پخش زنده بازی‌ها', 'callback_data' => "LG"]]
        ]
    ], JSON_UNESCAPED_UNICODE);
    // متن جدید زیر گیف
    $welcome = "سلام 🤝 به مینی‌اپ فوتبالی لایوکیوب خوش اومدی!\n\nبرای بروزرسانی ربات همیشه استارت مجدد کنید. ⬇️\n/start";
    $gifUrl = 'https://www.livefootball.space/LiveScore/assets/welcome.mp4';
    $localFile = new CURLFile(__DIR__ . '/assets/welcome.mp4', 'video/mp4', 'welcome.mp4');
    sendAnimation($chatId, $localFile, $welcome, $keyboard);
}