<?php

require_once 'persiantranslate.php';
require_once 'config.php';

try {
    $db = new PDO("mysql:host=localhost;dbname={$Db_Name};charset=utf8mb4", $Db_Username, $Db_Password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("خطا در اتصال به دیتابیس: " . $e->getMessage());
}

function convertToPersianNumbers($input) {
    $persian_digits = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $english_digits = ['0','1','2','3','4','5','6','7','8','9'];
    return str_replace($english_digits, $persian_digits, $input);
}

function getStatusText($eps) {
    switch ($eps) {
        case '1H':
        case '1st':
            return 'نیمه اول';
        case 'HT':
            return '🔥 بین دو نیمه';
        case '2H':
        case '2nd':
            return 'نیمه دوم';
        case 'ET':
            return 'وقت اضافه';
        case 'P':
            return 'پنالتی';
        case 'FT':
            return 'پایان بازی';
        case 'NS':
            return 'شروع نشده';
        default:
            return $eps;
    }
}

// --- تبدیل میلادی به شمسی (بدون وابستگی) ---
function gregorian_to_jalali($gy,$gm,$gd){
    $g_d_m = [0,31,59,90,120,151,181,212,243,273,304,334];
    $gy -= 1600; $gm -= 1; $gd -= 1;

    $g_day_no = 365*$gy + intdiv($gy+3,4) - intdiv($gy+99,100) + intdiv($gy+399,400);
    $g_day_no += $g_d_m[$gm] + $gd;

    // سال کبیسه میلادی
    if ($gm > 1) {
        $gy_abs = $gy + 1600;
        if (($gy_abs % 4 == 0 && $gy_abs % 100 != 0) || ($gy_abs % 400 == 0)) {
            $g_day_no++;
        }
    }

    $j_day_no = $g_day_no - 79;
    $j_np = intdiv($j_day_no, 12053);      // چرخه‌های 33 ساله
    $j_day_no %= 12053;

    $jy = 979 + 33*$j_np + 4*intdiv($j_day_no,1461);
    $j_day_no %= 1461;

    if ($j_day_no >= 366) {
        $jy += intdiv($j_day_no - 1, 365);
        $j_day_no = ($j_day_no - 1) % 365;
    }

    for ($jm = 0; $jm < 11 && $j_day_no >= ($jm < 6 ? 31 : 30); $jm++) {
        $j_day_no -= ($jm < 6 ? 31 : 30);
    }
    $jm += 1;
    $jd = $j_day_no + 1;

    return [$jy, $jm, $jd];
}

function gregorianToJalaliDate($gDateStr){
    // ورودی: 'YYYY-MM-DD'  → خروجی: 'YYYY-MM-DD' شمسی
    if (!$gDateStr) return '';
    $date = substr($gDateStr, 0, 10);
    $parts = explode('-', $date);
    if (count($parts) !== 3) return $gDateStr;

    [$gy, $gm, $gd] = array_map('intval', $parts);
    [$jy, $jm, $jd] = gregorian_to_jalali($gy, $gm, $gd);
    return sprintf('%04d-%02d-%02d', $jy, $jm, $jd);
}
