<?php
// index.php
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>لایوکیوب - مینی‌اپ فوتبال</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Bai+Jamjuree:wght@200;300;400;500;600;700&amp;family=Vazirmatn:wght@100..900&amp;display=swap" rel="stylesheet">

  <style>
    :root{
      --bg1:#0b0f16; --border:rgba(255,255,255,.10);
      --text:#e8eef7; --muted:#aab5c6; --accent:#ff7a1a;
    }
    body{
      margin:0; 
      padding:16px 16px calc(16px + env(safe-area-inset-bottom) + 72px); min-height:100dvh;
      min-height:100dvh;
      font-family:'Bai Jamjuree','Vazirmatn',sans-serif;
      color:var(--text);
      background:
        radial-gradient(900px 500px at 110% -20%, rgba(255,122,26,.10), transparent 60%),
        radial-gradient(700px 350px at -20% 120%, rgba(60,130,246,.10), transparent 60%),
        linear-gradient(180deg, #0a111a 0%, var(--bg1) 30%, #0a1118 100%);
    }
    .container{max-width:820px;margin:0 auto}
    
    .card{
      background: linear-gradient(180deg, rgba(76, 175, 80, 0.06), rgba(76, 175, 80, 0.03));
      border:1px solid var(--border); border-radius:6px;
      box-shadow:0 10px 30px rgba(0,0,0,.25); backdrop-filter: blur(6px);
    }
    .header-bar{display:flex;align-items:center;justify-content:space-between;direction:ltr}
    .brand{
      background: linear-gradient(90deg, #2E7D32 0%, #4CAF50 40%, #B2FF59 75%, #E8FFF7 100%);
      -webkit-background-clip: text;
      background-clip: text;
      color: transparent;
      filter: drop-shadow(0 2px 10px rgba(76,175,80,.25));
    }
    .league-wrap{padding:18px 16px 26px; overflow:visible}
    .hscroll{display:flex; gap:12px; overflow-x:auto; padding:2px 4px}
    .hscroll::-webkit-scrollbar{height:8px}
    .hscroll::-webkit-scrollbar-thumb{background:#2b3442;border-radius:6px}
    .league-box{
      min-width:90px; height:78px; display:flex; flex-direction:column; align-items:center; justify-content:center;
      background:linear-gradient(180deg, rgba(255,255,255,.05), rgba(255,255,255,.02));
      border:1px solid var(--border); border-radius:6px;
      transition:transform .15s ease, box-shadow .15s ease, border-color .15s ease;
    }
    .league-box:hover{ transform:translateY(-2px); border-color:rgba(76, 175, 80, 0.06); box-shadow:0 16px 20px rgba(76, 175, 80, 0.06)}
    .chips{display:flex;align-items:center;justify-content:space-between;gap:12px;margin-bottom:10px}
    .chip{
      padding:.35rem .7rem; border-radius:6px; font-weight:700; font-size:14px;
      border:1px solid var(--border); background:rgba(255,255,255,.05)
    }
    .chip-live{background:rgba(76, 175, 80, 0.2); color:#4CAF50; border-color:rgba(76, 175, 80, 0.5); animation:livePulse 1.6s ease-in-out infinite;}
    @keyframes livePulse{
      0%,100%{opacity:1}
      50%{opacity:.55}
    }
    .chip-title{color: #4CAF50; display:flex; align-items:center; gap:8px}
    .match{background:rgba(255,255,255,.02); border:1px solid var(--border); border-radius:6px; padding:12px; margin-bottom:12px}
    .league-title{font-weight:600; font-size:16px; margin-bottom:8px; margin-top:8px; display:flex; align-items:center; gap:12px; color:#ccc !importante;}
    
.teams{
  display:grid;
  grid-template-columns: 30px 1fr auto 1fr 30px; /* لوگو | نام میزبان | اسکور ثابت | نام میهمان | لوگو */
  align-items:center;
  column-gap:8px;
  font-size:14px;
  width:100%;
}

.teams .score{
  width:56px;                 /* عرض ثابت؛ می‌تونی 52–60 بزاری */
  text-align:center;
  font-variant-numeric:tabular-nums;
  font-weight:500;
  font-size:14px;
  padding:0.1rem 0.5rem;
  border-radius:6px;
  background:rgba(255,255,255,.06);
  border:1px solid var(--border);
  justify-self:center;        /* دقیقاً وسط ستون می‌ایسته */
}

.team-name{
  overflow:hidden;
  text-overflow:ellipsis;
  white-space:nowrap;
  min-width:0;   /* خیلی مهم برای Grid که ellipsis کار کنه */
}

.home-name{ 
  text-align:right;    /* چون ستون دومه و RTL هستیم */
  justify-self:end;    /* به اسکور نزدیک می‌ایسته */
  margin:0;
}
.away-name{ 
  text-align:left;     /* ستون چهارم؛ از سمت اسکور شروع میشه */
  justify-self:start;
  margin:0;
}

.team-logo{
  width:30px; height:30px;
  border-radius:50%;
  object-fit:cover;
  display:block;     /* جلوگیری از فاصله baseline */
}

    .minute{
      margin-top:6px; display:flex; justify-content:center;
      font-size:14px; color:#c9d3e5; text-align: center;
    }
    .scorers{
      font-size:13px; margin-top:10px; padding:10px;
      background:rgba(255,255,255,.04); border:1px solid var(--border); border-radius:6px;
      line-height:1.6;
    }
    .scorer-team{color:#F3FF69; font-weight:700; display:inline-block; margin-bottom:4px}
    @media (max-width:600px){
        .teams{gap:8px; font-size:12px; grid-template-columns: 26px 1fr auto 1fr 26px;}
        .league-title{font-size:14px}
        .teams .score{font-size:11px; padding:.01rem .09rem; width:36px;}
        
    }
    /* Bottom Navigation */
    .bottom-nav{
      position:fixed; left:0; right:0; bottom:0; z-index:50;
      background:rgba(10,17,26,.85);
      border-top:1px solid var(--border);
      backdrop-filter: blur(8px);
    }
    .bottom-nav .wrap{display:flex; justify-content:space-between; gap:4px}
    .bottom-nav a.item{
      flex:1; padding:8px 0 10px; text-align:center; font-size:12px;
      color:var(--muted); text-decoration:none;
      display:flex; flex-direction:column; align-items:center; gap:4px;
    }
    .bottom-nav a.item i{font-size:18px}
    .bottom-nav a.item.active{color:#4CAF50}
    .bottom-nav .safe{height:env(safe-area-inset-bottom)}
  </style>
</head>

<body>
  <div class="container">
    <!-- Header -->
<header class="card header-bar"
        style="padding:14px 16px; display:flex; justify-content:space-between; align-items:center; flex-direction:row-reverse;">
    <h1 class="text-2xl md:text-3xl brand"
    style="font-weight:800;">
      لایوکیوب
    </h1>

    <div style="display:flex;gap:10px">
      <button id="openSearchBtn"
              class="w-12 h-12 rounded-full flex items-center justify-center border border-[color:var(--border)]"
              style="background:linear-gradient(180deg, #1a2331, #121a26)" title="جستجو">
        <i class="fas fa-search text-gray-200"></i>
      </button>
    </div>
</header>
 <!--Promo Ribbon (A) — Mobile-first (Centered Title/Sub) -->
<section class="card promoA" style="margin-top:14px; padding:16px;">
  <div class="promoA-row" style="display:flex; flex-direction:column; gap:14px; align-items:center; text-align:center;">
    
    <div class="promoA-head" style="display:flex; flex-direction:column; align-items:center; gap:10px;">
      <div class="promoA-icon" style="width:48px;height:48px;border-radius:6px;border:1px solid var(--border);background:linear-gradient(180deg, rgba(255,255,255,.08), rgba(255,255,255,.03));display:flex;align-items:center;justify-content:center;font-size:24px;">🏆</div>
      <div>
        <div class="promoA-title" style="font-weight:900; font-size:18px; letter-spacing:.2px;">پیش‌بینی رایگان، جایزه واقعی!</div>
      </div>
    </div>

<a class="promoA-cta" href="https://t.me/KickPredict_bot?start=ls_top_banner"
   style="display:inline-flex; align-items:center; justify-content:center; gap:8px; width:100%;
          padding:.75rem 1rem; font-weight:700; font-size:16px; text-decoration:none;
          border-radius:6px; background: linear-gradient(90deg,#4CAF50 0%,#FFD54F 100%); color: #0b0f16;
          box-shadow: 0 8px 22px rgba(255,213,79,.3); inset 0 -2px 0 rgba(0,0,0,.12);">
   همین الان کلیک کن
</a>

  </div>
</section>

<style>
  /* انیمیشن چشمک ملایم */
  @keyframes pulseGlow {
    0%, 100% {
      filter: brightness(1);
      box-shadow: 0 10px 24px rgba(255,122,26,.28), inset 0 -2px 0 rgba(0,0,0,.12);
    }
    50% {
      filter: brightness(1.2);
      box-shadow: 0 0 16px rgba(255,122,26,.6), 0 0 28px rgba(255,122,26,.35);
    }
  }

  .promoA-cta {
    animation: pulseGlow 1.6s infinite ease-in-out;
    transition: transform .15s ease;
  }

  .promoA-cta:hover {
    filter: brightness(1.25);
    transform: translateY(-1px);
  }
</style>

<style>
  @media (min-width: 640px){
    .promoA .promoA-row{max-width:500px;margin:0 auto;}
    .promoA .promoA-cta{width:auto; padding:.65rem 1.1rem; font-size:13px;}
  }
  .promoA .promoA-cta:hover{filter:brightness(1.03);}
  .promoA .promoA-cta:active{transform:translateY(1px);}
</style>

<style>
  /* فقط مخصوص همین ریبن */
  @media (min-width: 640px){
    .promoA .promoA-row{
      flex-direction:row; align-items:center; justify-content:space-between;
    }
    .promoA .promoA-cta{
      width:auto; padding:.65rem 1.1rem; font-size:13px;
    }
  }
  .promoA .promoA-cta:hover{ filter:brightness(1.03); }
  .promoA .promoA-cta:active{ transform:translateY(1px); }
</style>

    <!-- Top Leagues -->
    <!--<section class="card league-wrap" style="margin-top:14px">-->
    <!--  <div class="hscroll">-->
    <!--    <a class="league-box">-->
    <!--        <img src="https://www.livefootball.space/LiveScore/leaguelogo/PL.svg" class="w-12 h-12 mb-1" alt="PL">-->
    <!--    </a>-->
    <!--    <a class="league-box">-->
    <!--        <img src="https://www.livefootball.space/LiveScore/leaguelogo/LL.svg" class="w-12 h-12 mb-1" alt="LL">-->
    <!--    </a>-->
    <!--    <a class="league-box">-->
    <!--        <img src="https://www.livefootball.space/LiveScore/leaguelogo/SA.svg" class="w-12 h-12 mb-1" alt="SA">-->
    <!--    </a>-->
    <!--    <a class="league-box">-->
    <!--        <img src="https://www.livefootball.space/LiveScore/leaguelogo/BL.svg" class="w-12 h-12 mb-1" alt="BL">-->
    <!--    </a>-->
    <!--    <a class="league-box">-->
    <!--        <img src="https://www.livefootball.space/LiveScore/leaguelogo/L1.svg" class="w-12 h-12 mb-1" alt="L1">-->
    <!--    </a>-->
    <!--  </div>-->
    <!--</section>-->

    <!-- Live Matches -->
    <section class="card" style="margin-top:14px; padding:14px 16px">
      <!-- 4) چیپ‌ها: عنوان راست، LIVE چپ -->
      <div class="chips">
        <span class="chip chip-title"><i></i> نتایج زنده</span>
        <span class="chip chip-live">بازی های این لحظه</span>
      </div>

      <div id="live-results-container" class="live-results">
        <p class="text-center py-4" style="color:var(--muted)">در حال دریافت نتایج...</p>
      </div>
    </section>
  </div>

<!-- Search Modal -->
<div id="searchModal" class="fixed inset-0 hidden z-50" dir="rtl" aria-hidden="true">
  <div class="absolute inset-0 bg-black/60"></div>
  <div class="relative flex h-full w-full items-end sm:items-center justify-center p-10 sm:p-10">
    <div role="dialog" aria-modal="true" aria-labelledby="searchTitle"
         class="w-full sm:max-w-md mx-auto rounded-t-2xl sm:rounded-2xl border border-[color:var(--border)]
                p-4 sm:p-5 shadow-2xl"
         style="background:linear-gradient(180deg,#1a2331,#121a26)">

      <form id="searchForm" class="space-y-4">
        <h2 id="searchTitle" class="text-gray-100 text-lg sm:text-xl font-bold">جستجوی تیم</h2>

        <label for="teamInput" class="sr-only">نام تیم</label>
        <div class="flex items-center gap-2 rounded-lg border border-white/15 bg-white/5 px-3">
          <i class="fas fa-search text-gray-300"></i>
          <input id="teamInput" type="text"
                 class="w-full bg-transparent outline-none py-3 text-gray-100 placeholder-gray-400
                        text-base sm:text-lg"
                 placeholder="نام تیم را به فارسی یا لاتین وارد کنید!"
                 inputmode="text" autocomplete="off" />
        </div>

        <!-- Actions: stack on mobile, row on ≥sm -->
        <div class="flex flex-col-reverse sm:flex-row gap-2 sm:justify-end">
          <button type="button" id="closeSearch"
                  class="px-4 py-2 rounded-md border border-white/20 text-gray-100 hover:bg-white/10">
            بستن
          </button>
          <button type="submit"
                  class="px-4 py-2 rounded-md text-white hover:opacity-90"
                  style="background:#4CAF50">
            جستجو
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  const openBtn = document.getElementById('openSearchBtn');
  const modal   = document.getElementById('searchModal');
  const closeBt = document.getElementById('closeSearch');
  const form    = document.getElementById('searchForm');
  const input   = document.getElementById('teamInput');

  openBtn.addEventListener('click', ()=>{ modal.classList.remove('hidden'); setTimeout(()=>input.focus(),10); });
  closeBt.addEventListener('click', ()=> modal.classList.add('hidden'));
  modal.addEventListener('click', e=>{ if(e.target===modal) modal.classList.add('hidden'); });
  document.addEventListener('keydown', e=>{ if(e.key==='Escape') modal.classList.add('hidden'); });

  form.addEventListener('submit', (e)=>{
    e.preventDefault();
    const q = input.value.trim();
    if(!q) return;
    // مسیر نتایج جستجو
    window.location.href = 'search_teams.php?q=' + encodeURIComponent(q);
  });
</script>

<script>

    function postProcessLiveHtml(){
      const wrap = document.getElementById('live-results-container');

      // اگر گلزنان بیرون کارت بعد از match آمده، ببر داخل همان کارت
      const list = Array.from(wrap.querySelectorAll('.match + .scorers'));
      list.forEach(s => {
        const prev = s.previousElementSibling;
        if (prev && prev.classList.contains('match')) prev.appendChild(s);
      });

      // اگر minute به‌صورت data-minute روی match آمد، زیر اسکور نمایش بده
      Array.from(wrap.querySelectorAll('.match')).forEach(m => {
        let min = m.querySelector('.minute');
        if (!min && m.dataset.minute) {
          min = document.createElement('div');
          min.className = 'minute';
          min.textContent = m.dataset.minute; // مثال: 73'
          m.querySelector('.teams')?.after(min);
        }
      });
    }

    function loadLiveResults() {
      fetch('live.php?fetch=1&t=' + Date.now())
        .then(r => { if(!r.ok) throw new Error(); return r.json(); })
        .then(data => {
          const el = document.getElementById('live-results-container');
          el.innerHTML = data.html ? data.html : '<p class="text-center py-4" style="color:#aab5c6">هیچ بازی فعالی وجود ندارد</p>';
          postProcessLiveHtml();
        })
        .catch(() => {
          document.getElementById('live-results-container').innerHTML =
            '<p class="text-center py-4 text-red-400">خطا در دریافت نتایج زنده</p>';
        });
    }
    loadLiveResults();
    setInterval(loadLiveResults, 30000);
  </script>

<script src="https://telegram.org/js/telegram-web-app.js"></script>

<script>
(function(){
  var tg = window.Telegram && Telegram.WebApp ? Telegram.WebApp : null;
  var user = tg && tg.initDataUnsafe ? tg.initDataUnsafe.user : null;
  var extId = user && user.id ? String(user.id) : null;

  // اگر خارج از تلگرام باز شد، یک guest id ساده بسازیم
  if(!extId){
    var g = localStorage.getItem('lc_guest');
    if(!g){ g = 'guest-' + Math.random().toString(36).slice(2) + Date.now().toString(36); localStorage.setItem('lc_guest', g); }
    extId = g;
  }

  fetch('https://www.livefootball.space/LiveScore/track.php', {
    method:'POST',
    headers:{
      'Content-Type':'application/json',
      'X-Track-Secret':'MY_SUPER_SECRET_123' // همان سکرت
    },
    body: JSON.stringify({
      provider: (user ? 'telegram' : 'guest'),
      external_id: extId,
      source: (user ? 'miniapp' : 'web'),
      event_type: 'open_app'
    })
  }).catch(function(){});
})();
</script>

<script>
  (function(){
    var path = location.pathname.toLowerCase();
    var map = {
      'matches':'index.html',
      'calendar':'calendar.php',
      'tables':'standings.php',
      'news':'feed.php',
      'predict':'t.me' // لینک بیرونی
    };
    document.querySelectorAll('.bottom-nav a.item').forEach(function(a){
      var tab = a.getAttribute('data-tab');
      if(!tab) return;
      if((tab==='predict' && location.href.includes('t.me')) ||
         (map[tab] && path.includes(map[tab].split('?')[0]))) {
        a.classList.add('active');
      }
      if(tab==='matches' && (path.endsWith('/') || path.endsWith('/index.php') || path.endsWith('/index.html'))){
        a.classList.add('active');
      }
    });
  })();
</script>

        <?php $active='matches'; include __DIR__.'/parts/bottom-nav.php'; ?>

</body>
</html>
