<?php

require_once 'functions.php';
require_once 'persiantranslate.php';
$My_Ligs = [
    21997, 22091, 21862, 22118, 22180, 22694, 22724, 21841, 22024, 22001, 22225,
    22452, 20159, 20064, 22005, 21812, 21815, 21716, 22075, 21969, 22061, 22093,
    22862, 20094, 20095, 20096, 20097, 20098, 20099, 20100, 20101, 20102, 20103,
    20104, 20105, 14433, 22945, 22936, 22943, 22541, 22937, 23132, 22094, 22938,
    23138, 23139, 21891, 22095, 21970, 23590, 20065, 23783, 21971, 22076, 23579,
    23722
];

if (isset($_GET['fetch']) && $_GET['fetch'] === '1') {
    header('Content-Type: application/json');

    $cacheFile = 'live_cache.json';
    if (file_exists($cacheFile) && time() - filemtime($cacheFile) < 10) {
        echo file_get_contents($cacheFile);
        exit;
    }

    $url = 'https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30';
    $response = file_get_contents($url);
    if ($response === false) {
        echo json_encode(['error' => 'خطا در دریافت اطلاعات']);
        exit;
    }

    $data = json_decode($response, true);
    $leagueMatches = [];

    if (isset($data['Stages']) && count($data['Stages']) > 0) {
        foreach ($data['Stages'] as $stage) {
            if (!in_array($stage['Sid'] ?? 0, $My_Ligs)) {
                continue;
            }

            // $leagueTitle = getleagues($stage['Cnm'] ?? '') . ' / ' . getleagues($stage['Snm'] ?? 'لیگ');
            $leagueTitle = getleagues($stage['Snm'] ?? 'لیگ');

            $compCode = $stage['CompImg'] ?? '';
            $compLogoUrl = $compCode ? "https://lsm-static-prod.livescore.com/medium/$compCode.png" : '';
            
            $leagueName = $compLogoUrl
                ? "<span class='league-title'><img src='$compLogoUrl' style='width:20px;height:20px;vertical-align:middle;margin-left:8px;'> " . getleagues($leagueTitle) . "</span>"
                : "<span class='league-title'>" . getleagues($leagueTitle) . "</span>";

            foreach ($stage['Events'] as $event) {
                ob_start();

                $home = getTeamName($event['T1'][0]['Nm'] ?? 'Team A');
                $away = getTeamName($event['T2'][0]['Nm'] ?? 'Team B');
                $score = convertToPersianNumbers(($event['Tr1'] ?? '?')) . " - " . convertToPersianNumbers(($event['Tr2'] ?? '?'));
                $minute = convertToPersianNumbers(getStatusText($event['Eps'] ?? 'نامشخص'));
                $eventId = $event['Eid'] ?? null;

                $homeLogo = 'https://lsm-static-prod.livescore.com/medium/' . ($event['T1'][0]['Img'] ?? '');
                $awayLogo = 'https://lsm-static-prod.livescore.com/medium/' . ($event['T2'][0]['Img'] ?? '');

                // $scorers = getMatchScorers($eventId);
                // $homeScorers = $scorers['home'] ?? '';
                // $awayScorers = $scorers['away'] ?? '';
                ?>
                <div class="match card">
                    <div class="teams">
                        <img src="<?= $homeLogo ?>" class="team-logo">
                        <span class="team-name home-name"><?= $home ?></span>
                        <span class="score"><?= $score ?: '—' ?></span>
                        <span class="team-name away-name"><?= $away ?></span>
                        <img src="<?= $awayLogo ?>" class="team-logo">
                    </div>
                    <div class="minute"><?= $minute ?></div>
                        <div class="match-details">
                            <button class="details-btn" onclick="window.location.href='match_events.php?eid=<?= htmlspecialchars($eventId) ?>'">
                                <span></span> جزئیات کامل بازی
                            </button>
                        </div>
                    
                    <style>
                    .match-details {
                        margin-top: 10px;
                        display: flex;
                        justify-content: center;
                    }
                    .details-btn {
                        display: inline-flex;
                        align-items: center;
                        gap: 6px;
                        padding: 0.5rem 1rem;
                        border-radius: 4px;
                        background: linear-gradient(90deg, rgba(76,175,80,0.15), rgba(76,175,80,0.05));
                        border: 1px solid var(--border);
                        color: var(--text);
                        text-decoration: none;
                        font-family: 'Bai Jamjuree','Vazirmatn',sans-serif;
                        font-size: 13px;
                        font-weight: 500;
                        transition: all 0.2s ease;
                    }
                    .details-btn:hover {
                        background: linear-gradient(90deg, rgba(76,175,80,0.3), rgba(76,175,80,0.15));
                        transform: translateY(-1px);
                        box-shadow: 0 3px 10px rgba(76,175,80,0.2);
                    }
                    .details-btn span {
                        font-size: 15px;
                    }
                    </style>
                </div>                      
                    <!--  <?php if (!empty($homeScorers) || !empty($awayScorers)): ?>-->
                    <!--    <div class="scorers">-->
                    <!--      <?php if (!empty($homeScorers)): ?>-->
                    <!--        <div><span class="scorer-team"><?= $home ?>:</span> <?= $homeScorers ?></div>-->
                    <!--      <?php endif; ?>-->
                    <!--      <?php if (!empty($awayScorers)): ?>-->
                    <!--        <div><span class="scorer-team"><?= $away ?>:</span> <?= $awayScorers ?></div>-->
                    <!--      <?php endif; ?>-->
                    <!--    </div>-->
                    <!--  <?php endif; ?>-->
                    <!--</div>-->
                <?php
                $leagueMatches[$leagueName][] = ob_get_clean();
            }
        }
    }

    $html = '';
    foreach ($leagueMatches as $league => $matches) {
        $html .= "<div class='league-section'>";
        $html .= "<div class='league-title'>" . getleagues($league) . "</div>";
        $html .= implode('', $matches);
        $html .= "</div>";
    }

    if (empty($html)) {
    $html = "<div class='match'>❌ درحال حاضر هیچ بازی فعالی وجود ندارد.<br><br>📆 برای مشاهده بازی های امروز، روی تقویم کلیک کنید.</div>";
    }

// if (empty($html)) {
//     $html = "
//     <div class='match'>
//         <h3>🔥 مهم‌ترین بازی‌های امروز (۷ آبان ۱۴۰۴)</h3>
//         <br>
        
//         <h4>🔮 سری آ</h4>
//         <ul>
//             <li>🔹 آاس رم ۲۰:۰۰ پارما</li>
//             <li>🔹 یوونتوس ۲۰:۰۰ اودینزه</li>
//             <li>🔹 اینتر ۲۲:۱۵ فیورنتینا</li>
//         </ul>
//         <br>

//         <h4>🔮 لیگ ۱ فرانسه</h4>
//         <ul>
//             <li>🔹 لوریان ۲۰:۳۰ پاری‌سن‌ژرمن</li>
//         </ul>
//         <br>

//         <h4>🔮 جام حذفی انگلیس: یک هشتم نهایی</h4>
//         <ul>
//             <li>🔹 آرسنال ۲۲:۱۵ برایتون</li>
//             <li>🔹 لیورپول ۲۲:۱۵ کریستال پالاس</li>
//             <li>🔹 سوانزی ۲۲:۱۵ منچسترسیتی</li>
//             <li>🔹 ولورهمپتون ۲۲:۱۵ چلسی</li>
//             <li>🔹 نیوکاسل یونایتد ۲۲:۳۰ تاتنهام</li>
//         </ul>
//         <br>

//         <h4>🔮 جام حذفی آلمان: یک شانزدهم</h4>
//         <ul>
//             <li>🔹 کلن ۲۲:۱۵ بایرن مونیخ</li>
//         </ul>
//     </div>
//     ";
// }

    $result = json_encode(['html' => $html]);
    file_put_contents($cacheFile, $result);
    echo $result;
    exit;
}
function getMatchScorers($eventId) {
    if (!$eventId) return ['home' => '', 'away' => ''];

    $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/scoreboard/soccer/{$eventId}?locale=en";
    $response = file_get_contents($url);
    if (!$response) return ['home' => '', 'away' => ''];

    $data = json_decode($response, true);

    $homeScorers = '';
    $awayScorers = '';

    if (!isset($data['Incs-s']) || !is_array($data['Incs-s'])) {
        return ['home' => '', 'away' => ''];
    }

    foreach ($data['Incs-s'] as $teamEvents) {
        foreach ($teamEvents as $event) {
            $eventsToCheck = [];

            // خود event اگر گل بود
            if (isset($event['IT']) && in_array($event['IT'], [36, 37, 39])) {
                $eventsToCheck[] = $event;
            }

            // گل‌های داخل Incs
            if (isset($event['Incs']) && is_array($event['Incs'])) {
                foreach ($event['Incs'] as $innerEvent) {
                    if (isset($innerEvent['IT']) && in_array($innerEvent['IT'], [36, 37])) {
                        $eventsToCheck[] = $innerEvent;
                    }
                }
            }

            foreach ($eventsToCheck as $goalEvent) {
                $player = trim(($goalEvent['Fn'] ?? '') . ' ' . ($goalEvent['Ln'] ?? ''));
                if (empty($player) && isset($goalEvent['Pn'])) {
                    $player = trim($goalEvent['Pn']);
                }
                if (empty($player)) continue;

                $minute = $goalEvent['Min'] ?? '?';
                $isPenalty = ($goalEvent['IT'] == 37);
                $isOwnGoal = ($goalEvent['IT'] == 39);
                $penText = $isPenalty ? ' (PEN)' : '';
                $ogText = $isOwnGoal ? ' OG' : '';
                $text = "⚽ $player ($minute'$penText$ogText)";

                $teamNumber = $goalEvent['Nm'] ?? null;

                if ($teamNumber == 1) {
                    $homeScorers .= $text . ' ';
                } elseif ($teamNumber == 2) {
                    $awayScorers .= $text . ' ';
                }
            }
        }
    }

    return [
        'home' => trim($homeScorers),
        'away' => trim($awayScorers)
    ];
}
?>
