<?php
// $pageTitle = 'اخبار روز';
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Bai+Jamjuree:wght@200;300;400;500;600;700&family=Vazirmatn:wght@100..900&display=swap" rel="stylesheet">

  <style>
    :root {
      --border: rgba(255, 255, 255, .12);
      --text: #e8eef7;
      --muted: #aab5c6;
      --accent: #4CAF50;
      --bg1: #0b0f16;
    }

    body {
      margin: 0;
      padding: 16px 16px calc(16px + env(safe-area-inset-bottom) + 72px);
      min-height: 100dvh;
      font-family: 'Bai Jamjuree', 'Vazirmatn', sans-serif;
      color: var(--text);
      background:
        radial-gradient(900px 500px at 110% -20%, rgba(255, 122, 26, .10), transparent 60%),
        radial-gradient(700px 350px at -20% 120%, rgba(60, 130, 246, .10), transparent 60%),
        linear-gradient(180deg, #0a111a 0%, var(--bg1) 30%, #0a1118 100%);
    }

    .container {
      max-width: 820px;
      margin: 0 auto;
    }

    .card {
      background: linear-gradient(180deg, rgba(255, 255, 255, .06), rgba(255, 255, 255, .03));
      border: 1px solid var(--border);
      border-radius: 12px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, .25);
      backdrop-filter: blur(6px);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .card:hover {
      transform: translateY(-4px);
      box-shadow: 0 15px 40px rgba(0, 0, 0, .3);
    }

    .header-bar {
      display: flex;
      align-items: center;
      justify-content: space-between;
      direction: ltr;
    }

    .brand {
      background: linear-gradient(90deg, #2E7D32 0%, #4CAF50 40%, #B2FF59 75%, #E8FFF7 100%);
      -webkit-background-clip: text;
      background-clip: text;
      color: transparent;
      filter: drop-shadow(0 2px 10px rgba(76,175,80,.25));
    }

    .news-image {
      width: 80px;
      height: 80px;
      object-fit: cover;
      border-radius: 8px;
      border: 1px solid var(--border);
      flex-shrink: 0;
    }

    .bottom-nav {
      position: fixed;
      left: 0;
      right: 0;
      bottom: 0;
      z-index: 50;
      background: rgba(10, 17, 26, .85);
      border-top: 1px solid var(--border);
      backdrop-filter: blur(8px);
    }

    .bottom-nav .wrap {
      display: flex;
      justify-content: space-between;
      gap: 4px;
    }

    .bottom-nav a.item {
      flex: 1;
      padding: 8px 0 10px;
      text-align: center;
      font-size: 12px;
      color: var(--muted);
      text-decoration: none;
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 4px;
    }

    .bottom-nav a.item i {
      font-size: 18px;
    }

    .bottom-nav a.item.active {
      color: var(--accent);
    }

    .bottom-nav .safe {
      height: env(safe-area-inset-bottom);
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Header -->
    <header class="card header-bar px-4 py-3 mb-4">
      <h1 class="text-xl md:text-2xl brand font-extrabold">LiveCube</h1>
    </header>

    <!-- عنوان صفحه -->
    <!--<div class="card flex items-center justify-between px-5 py-4 mb-4">-->
    <!--  <span class="text-lg font-semibold text-gray-200"><?= htmlspecialchars($pageTitle) ?></span>-->
    <!--</div>-->

    <!-- اخبار -->
    <div id="news-container" class="space-y-4">
      <div class="card p-4 text-center text-[var(--muted)]">در حال بارگذاری اخبار...</div>
    </div>
  </div>

  <script>
    document.addEventListener("DOMContentLoaded", async () => {
      const container = document.getElementById("news-container");

      try {
        const response = await fetch("https://www.livefootball.space/GetData/news/news_data.json");
        if (!response.ok) throw new Error("خطا در دریافت داده‌ها");

        const data = await response.json();
        container.innerHTML = "";

        if (!data.length) {
          container.innerHTML = `<div class="card p-4 text-center text-[var(--muted)]">هیچ خبری یافت نشد.</div>`;
          return;
        }

        data.forEach(item => {
          const imageUrl = item.img === 'Default.jpg'
            ? 'https://www.livefootball.space/GetData/news/Default.jpg'
            : `https://www.livefootball.space/GetData/news/photos/${item.img}`;

          const card = document.createElement("a");
          card.href = item.link;
          card.target = "_blank";
          card.className = "card p-4 flex gap-4 items-start hover:shadow-lg transition-all duration-300";

          card.innerHTML = `
            <img src="${imageUrl}" alt="${item.text}" class="news-image">
            <div class="flex flex-col">
              <div class="font-semibold text-sm mb-2">${item.text}</div>
              <div class="text-xs text-[var(--muted)]">${item.link.replace(/^https?:\/\//, '').split('/')[0]}</div>
            </div>
          `;

          container.appendChild(card);
        });
      } catch (error) {
        container.innerHTML = `<div class="card p-4 text-center text-red-500">خطا در بارگذاری اخبار: ${error.message}</div>`;
      }
    });
  </script>

  <?php $active='news'; include __DIR__.'/parts/bottom-nav.php'; ?>
</body>
</html>