<?php
require_once 'functions.php';

// لیگ‌ها
$leagues = [
  '65' => 'پریمیرلیگ (انگلستان)',
  '75' => 'لالیگا (اسپانیا)',
  '77' => 'سری آ (ایتالیا)',
  '67' => 'بوندسلیگا (آلمان)',
  '68' => 'لیگ یک (فرانسه)',
  '403'=> 'لیگ حرفه‌ای عربستان',
  '145'=> 'ام‌ال‌اس (آمریکا)',
  // ایران: مسیر stage به‌جای آیدی عددی
  'stage:iran/pro-league/2' => 'پرشین گلف (ایران)',
  '64' => 'اردیویزه (هلند)',
  '79' => 'پریمیرا لیگا (پرتغال)',
  '692' => 'لیگ نخبگان آسیا',
  '60' => 'لیگ قهرمانان اروپا: گروهی',
  '62' => 'لیگ کنفرانس اروپا: گروهی',
  '36' => 'لیگ اروپا: گروهی',
];

$sel = $_GET['competition'] ?? '65';
if (!array_key_exists($sel, $leagues)) $sel = '65';

if (strpos($sel, 'stage:') === 0) {
    // مثال: stage:iran/pro-league/2  →  iran/pro-league/2
    $stagePath = substr($sel, 6);
    $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/stage/soccer/{$stagePath}?locale=en";
} else {
    $id  = (string)$sel;
    $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/competition/{$id}/leagueTable/?locale=en";
}

$json  = @file_get_contents($url);
$data  = $json ? json_decode($json, true) : [];
$teams = $data['Stages'][0]['LeagueTable']['L'][0]['Tables'][0]['team'] ?? [];
if (!$teams && isset($data['Stage'])) {
    // بعضی پاسخ‌های stage ممکن است به‌صورت 'Stage' برگردند
    $teams = $data['Stage']['LeagueTable']['L'][0]['Tables'][0]['team'] ?? [];
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>جدول لیگ‌ها</title>
<script src="https://cdn.tailwindcss.com"></script>
<link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/fonts.css" rel="stylesheet">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Bai+Jamjuree:wght@200;300;400;500;600;700&amp;family=Vazirmatn:wght@100..900&amp;display=swap" rel="stylesheet">

<style>
:root{
  --border:rgba(255,255,255,.12); --muted:#aab5c6; --accent:#ff7a1a;
}
body{
  margin:0; padding:16px 16px calc(16px + env(safe-area-inset-bottom) + 72px); min-height:100dvh;
  min-height:100dvh; font-family:'Bai Jamjuree','Vazirmatn',sans-serif; color:#e8eef7;
  background:
    radial-gradient(900px 500px at 110% -20%, rgba(255,122,26,.10), transparent 60%),
    radial-gradient(700px 350px at -20% 120%, rgba(60,130,246,.10), transparent 60%),
    linear-gradient(180deg,#0a111a 0%, #0b0f16 30%, #0a1118 100%);
}
.container{max-width:900px;margin:0 auto}

.card{background:linear-gradient(180deg, rgba(76, 175, 80, 0.06), rgba(76, 175, 80, 0.06));
  border:1px solid var(--border); border-radius:8px; box-shadow:0 10px 30px rgba(0,0,0,.25);}

.header{display:flex;align-items:center;justify-content:space-between;padding:14px 16px}

.btn-icon{width:42px;height:42px;border-radius:9999px;display:flex;align-items:center;justify-content:center;
  border:1px solid var(--border); background:linear-gradient(180deg,#1a2331,#121a26)}

.select{background:#0f1723;border:1px solid var(--border);color:#e8eef7;border-radius:8px;padding:.55rem 5rem}
  a.btn{ padding:.45rem .7rem; border-radius:8px; background:#4CAF50; color:#ccc !importante; text-decoration:none; }

.table-wrap{overflow:auto}
table{width:100%; border-collapse:separate; border-spacing:0}
thead th{background:rgba(255,255,255,.06); border-bottom:1px solid var(--border); padding:.7rem; font-weight:700 }
tbody td{border-bottom:1px dashed var(--border); padding:.6rem}
.badge{color:var(--accent); font-weight:700}
.team-link{display:inline-flex; align-items:center; gap:.5rem; color:#e8eef7}
.team-link:hover{color:#fff}
.team-logo{width:22px;height:22px;border-radius:50%;object-fit:cover}

/* --- Responsive improvements for league tables --- */
.table-wrap{
  overflow:auto;
  -webkit-overflow-scrolling:touch;
  overscroll-behavior-x: contain;
  scroll-snap-type:x proximity;
}
table{ min-width: 760px; }               /* اجازه‌ی اسکرول افقی روی موبایل */

thead th{
  position: sticky; top: 0; z-index: 2;  /* هدر چسبان */
  backdrop-filter: blur(4px);
}

  .header-bar{display:flex;align-items:center;justify-content:space-between;direction:ltr}
  .brand{
    background:linear-gradient(90deg,#2E7D32 0%,#4CAF50 40%,#B2FF59 75%,#E8FFF7 100%);
    -webkit-background-clip:text; background-clip:text; color:transparent;
    filter: drop-shadow(0 2px 10px rgba(76,175,80,.25));
  }
  
/* Bottom Navigation */
.bottom-nav{
  position:fixed; left:0; right:0; bottom:0; z-index:50;
  background:rgba(10,17,26,.85);
  border-top:1px solid var(--border);
  backdrop-filter: blur(8px);
}
.bottom-nav .wrap{display:flex; justify-content:space-between; gap:4px}
.bottom-nav a.item{
  flex:1; padding:8px 0 10px; text-align:center; font-size:12px;
  color:var(--muted); text-decoration:none;
  display:flex; flex-direction:column; align-items:center; gap:4px;
}
.bottom-nav a.item i{font-size:18px}
.bottom-nav a.item.active{color:#4CAF50}
.bottom-nav .safe{height:env(safe-area-inset-bottom)}



/* ردیف‌ها جمع‌وجورتر روی موبایل */
@media (max-width: 640px){
  thead th{ padding:.55rem; font-size:13px }
  tbody td{ padding:.45rem; font-size:13px }
  .team-link{ gap:.35rem }
  .team-logo{ width:18px; height:18px }
}

/* جلوگیری از شکستن متن‌ها و کوچک‌تر کردن حداقل عرض روی موبایل‌های خیلی کوچک */
@media (max-width: 420px){
  table{ min-width: 620px; }
  thead th, tbody td{ white-space: nowrap; }
}

/* (اختیاری) اگر خواستی جدول فشرده‌تر شود، کلاس table-condensed بده */
.table-condensed thead th,
.table-condensed tbody td{ padding:.35rem .5rem; font-size:12.5px; }

/* (اختیاری) اگر لازم شد ستون‌های کم‌اهمیت را مخفی کنی، این را فعال کن
@media (max-width: 480px){
  td:nth-child(5), th:nth-child(5),
  td:nth-child(6), th:nth-child(6){ display:none; }
}
*/


</style>
</head>
<body>
    <div class="container">
        <!-- Header -->
    <header class="card header-bar px-4 py-3">
          <h1 class="text-xl md:text-2xl brand font-extrabold">LiveCube</h1>
    </header>

    <!-- انتخاب لیگ -->
<div class="card flex items-center justify-between" style="padding:20px 16px; margin-top:14px">
  <!-- عنوان سمت راست -->
  <span class="text-lg font-semibold text-gray-200">جدول لیگ‌ها</span>

  <!-- فرم سمت چپ -->
  <form method="GET" class="flex items-center gap-3">
    <select name="competition" class="select" onchange="this.form.submit()">
        <?php foreach ($leagues as $id => $name): ?>
          <option value="<?= htmlspecialchars((string)$id) ?>" <?= ((string)$id === (string)$sel ? 'selected' : '') ?>>
            <?= getLeagues($name) ?>
          </option>
        <?php endforeach; ?>
    </select>
  </form>
</div>

    <!-- جدول -->
    <div class="card" style="margin-top:14px; padding:6px 12px">
      <?php if (empty($teams)): ?>
        <div class="text-[var(--muted)] p-4">📭 جدول هنوز بارگذاری نشده یا مشکلی در دریافت اطلاعات وجود دارد.</div>
      <?php else: ?>
        <div class="table-wrap">
          <table>
            <thead>
              <tr>
                <th>رده</th>
                <th class="text-right">تیم</th>
                <th>بازی</th>
                <th>برد</th>
                <th>مساوی</th>
                <th>باخت</th>
                <th>امتیاز</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach ($teams as $t):
              $rank = convertToPersianNumbers($t['rnk'] ?? '-');
              $name = getTeamName($t['Tnm'] ?? '');
              $img  = "https://lsm-static-prod.livescore.com/medium/".($t['Img'] ?? '');
              $tid  = $t['Tid'] ?? $t['Id'] ?? $t['TeamId'] ?? null; // شناسه تیم برای team.php
            ?>
              <tr>
                <td><?= $rank ?></td>
                <td>
<?php if ($tid): ?>
  <a class="team-link" href="search_teams.php?q=<?= urlencode($name) ?>" title="جستجوی تیم">
    <img src="<?= htmlspecialchars($img) ?>" class="team-logo" alt="">
    <span><?= $name ?></span>
  </a>
<?php else: ?>
  <a class="team-link" href="search_teams.php?q=<?= urlencode($name) ?>" title="جستجوی تیم">
    <img src="<?= htmlspecialchars($img) ?>" class="team-logo" alt="">
    <span><?= $name ?></span>
  </a>
<?php endif; ?>

                </td>
                <td><?= convertToPersianNumbers($t['pld'] ?? 0) ?></td>
                <td><?= convertToPersianNumbers($t['win'] ?? 0) ?></td>
                <td><?= convertToPersianNumbers($t['drw'] ?? 0) ?></td>
                <td><?= convertToPersianNumbers($t['lst'] ?? 0) ?></td>
                <td><strong><?= convertToPersianNumbers($t['pts'] ?? 0) ?></strong></td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
  
  <?php $active='predict'; include __DIR__.'/parts/bottom-nav.php'; ?>

</body>
</html>
