<?php
function checkAPI($url, $headers = []) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_HEADER => true
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return $httpCode;
}

// تست از چند endpoint مختلف
$endpoints = [
    'https://prod-public-api.livescore.com/v1/api/app/live/soccer/3.30',
    'https://prod-public-api.livescore.com/v1/api/app/live/soccer',
    'https://prod-public-api.livescore.com/v1/api/app'
];

foreach ($endpoints as $endpoint) {
    $code = checkAPI($endpoint, [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
        'Accept: application/json'
    ]);
    echo "Endpoint: $endpoint | HTTP Code: $code\n";
}
?>