<?php
require_once 'functions.php';
require_once 'persiantranslate.php';

// لیست لیگ‌ها
$leagues = [
  '65' => 'پریمیرلیگ (انگلستان)',
  '75' => 'لالیگا (اسپانیا)',
  '77' => 'سری آ (ایتالیا)',
  '67' => 'بوندسلیگا (آلمان)',
  '68' => 'لیگ یک (فرانسه)',
  '403'=> 'لیگ حرفه‌ای عربستان',
//   '145'=> 'ام‌ال‌اس (آمریکا)',
  'stage:iran/pro-league/2' => 'پرشین گلف (ایران)',
  '64' => 'اردیویزه (هلند)',
  '79' => 'پریمیرا لیگا (پرتغال)',
    '692' => 'لیگ نخبگان آسیا',
  '60' => 'لیگ قهرمانان اروپا: گروهی',
  '62' => 'لیگ کنفرانس اروپا: گروهی',
  '36' => 'لیگ اروپا: گروهی',

];

// انتخاب لیگ
$sel = $_GET['competition'] ?? '65';
if (!array_key_exists($sel, $leagues)) $sel = '65';

// انتخاب نوع آمار (گل یا پاس گل)
$type = $_GET['type'] ?? 'goals'; // پیش‌فرض: گلزنان

// ساخت URL
if (strpos($sel, 'stage:') === 0) {
    $stagePath = substr($sel, 6);
    $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/stage/soccer/{$stagePath}/stat/?limit=50&locale=en";
} else {
    $id  = (string)$sel;
    $url = "https://prod-cdn-public-api.livescore.com/v1/api/app/competition/{$id}/stat/?limit=50&locale=en";
}

$json = @file_get_contents($url);
$data = $json ? json_decode($json, true) : [];

// گرفتن لیست بازیکنان
$players = [];
if (!empty($data['Stat'])) {
    foreach ($data['Stat'] as $stat) {
        if ($type === 'goals' && $stat['Typ'] == 1) {
            $players = $stat['Plrs'] ?? [];
        }
        if ($type === 'assists' && $stat['Typ'] == 3) {
            $players = $stat['Plrs'] ?? [];
        }
    }
}

$active = 'scorer';
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>بهترین‌ها</title>
<script src="https://cdn.tailwindcss.com"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Bai+Jamjuree:wght@200;300;400;500;600;700&amp;family=Vazirmatn:wght@100..900&amp;display=swap" rel="stylesheet">

<style>
:root{
  --border:rgba(255,255,255,.12); --muted:#aab5c6; --accent:#ff7a1a;
}
body{
  margin:0; padding:16px 16px calc(16px + env(safe-area-inset-bottom) + 72px); min-height:100dvh;
  font-family:'Bai Jamjuree','Vazirmatn',sans-serif; color:#e8eef7;
  background:linear-gradient(180deg,#0a111a 0%, #0b0f16 30%, #0a1118 100%);
}
.container{max-width:900px;margin:0 auto}

.card{background:linear-gradient(180deg, rgba(76, 175, 80, 0.06), rgba(76, 175, 80, 0.06));
  border:1px solid var(--border); border-radius:6px; box-shadow:0 10px 30px rgba(0,0,0,.25);}

.header-bar{display:flex;align-items:center;justify-content:space-between;direction:ltr}
.brand{background:linear-gradient(90deg,#2E7D32 0%,#4CAF50 40%,#B2FF59 75%,#E8FFF7 100%);
  -webkit-background-clip:text; background-clip:text; color:transparent;
  filter: drop-shadow(0 2px 10px rgba(76,175,80,.25));}

.select{background:#0f1723;border:1px solid var(--border);color:#e8eef7;border-radius:6px;padding:.55rem 5rem}

a.btn{ 
  padding:.45rem 1rem; 
  border-radius:6px; 
  background:linear-gradient(90deg, rgba(76,175,80,0.2), rgba(76,175,80,0.1));
  border:1px solid var(--border);
  color:#e8eef7; 
  text-decoration:none; 
  font-size:14px;
  font-weight:500;
  transition: all 0.3s ease;
  display:inline-flex; 
  align-items:center; 
  gap:6px;
}
a.btn:hover {
  background:linear-gradient(90deg, rgba(76,175,80,0.4), rgba(76,175,80,0.2));
  transform: translateY(-1px);
  box-shadow: 0 4px 12px rgba(76,175,80,0.3);
}
a.btn.active {
  background:linear-gradient(90deg, #ff7a1a, #ff9a5a);
  border-color:#ff7a1a;
  color:#fff;
  box-shadow: 0 4px 12px rgba(255,122,26,0.3);
}
a.btn.active:hover {
  background:linear-gradient(90deg, #e86b17, #ff8a4a);
  transform: translateY(-1px);
}

.table-wrap{overflow-x:hidden}
table{width:100%; border-collapse:separate; border-spacing:0;}
thead th{background:rgba(255,255,255,.06); border-bottom:1px solid var(--border); padding:.7rem; font-weight:500 }
tbody td{border-bottom:1px dashed var(--border); padding:.6rem}

  .table-wrap table { width: 100%; border-collapse: collapse; direction: rtl; }
  .table-wrap th, .table-wrap td { padding: 8px 12px; }

  /* تیترها دقیقا بالای شروع محتوای هر ستون */
  .table-wrap th:nth-child(1), .table-wrap td:nth-child(1) { text-align: center;  } /* رده */
  .table-wrap th:nth-child(2), .table-wrap td:nth-child(2) { text-align: right;   } /* بازیکن */
  .table-wrap th:nth-child(3), .table-wrap td:nth-child(3) { text-align: center;  } /* گل/پاس گل */

  .table-wrap th { white-space: nowrap; font-weight: 600; }

  /* چیدمان تمیزتر برای سلول بازیکن */
  .table-wrap .player-cell { display: flex; flex-direction: column; gap: 2px; }
  .table-wrap .player-name  { font-weight: 600; }
  .table-wrap .team-name    { font-size: .9rem; opacity: .8; }

.player-cell{display:flex; flex-direction:column; gap:2px;}
.player-name{font-size:14px; font-weight:500;}
.team-name{font-size:12px; color:var(--muted);}

/* Bottom Navigation */
.bottom-nav{
  position:fixed; left:0; right:0; bottom:0; z-index:50;
  background:rgba(10,17,26,.85);
  border-top:1px solid var(--border);
  backdrop-filter: blur(8px);
}
.bottom-nav .wrap{display:flex; justify-content:space-between; gap:4px}
.bottom-nav a.item{
  flex:1; padding:8px 0 10px; text-align:center; font-size:12px;
  color:var(--muted); text-decoration:none;
  display:flex; flex-direction:column; align-items:center; gap:4px;
}
.bottom-nav a.item i{font-size:18px}
.bottom-nav a.item.active{color:#4CAF50}
.bottom-nav .safe{height:env(safe-area-inset-bottom)}
</style>
</head>
<body>
<div class="container">

    <!-- Header -->
    <header class="card header-bar px-4 py-3">
        <h1 class="text-xl md:text-2xl brand font-extrabold">LiveCube</h1>
    </header>

    <!-- انتخاب لیگ -->
    <div class="card flex items-center justify-between" style="padding:20px 16px; margin-top:14px">
        <span class="text-lg font-semibold text-gray-200">بهترین‌ها</span>
        <form method="GET" class="flex items-center gap-3">
            <select name="competition" class="select" onchange="this.form.submit()">
                <?php foreach ($leagues as $id => $name): ?>
                  <option value="<?= htmlspecialchars((string)$id) ?>" <?= ((string)$id===$sel?'selected':'') ?>>
                    <?= getLeagues($name) ?>
                  </option>
                <?php endforeach; ?>
            </select>
            <input type="hidden" name="type" value="<?= htmlspecialchars($type) ?>">
        </form>
    </div>

    <!-- دکمه‌های گلزن/پاسور -->
    <div class="card flex gap-4 justify-center mt-3 p-4">
        <a href="?competition=<?= $sel ?>&type=goals" class="btn <?= $type==='goals'?'active':'' ?>">
          <span></span> بهترین گلزنان
        </a>
        <a href="?competition=<?= $sel ?>&type=assists" class="btn <?= $type==='assists'?'active':'' ?>">
          <span></span> بهترین پاسورها
        </a>
    </div>

    <!-- جدول -->
    <div class="card" style="margin-top:14px; padding:6px 12px">
      <?php if (empty($players)): ?>
        <div class="text-[var(--muted)] p-4">📭 اطلاعات آماری در دسترس نیست.</div>
      <?php else: ?>
        <div class="table-wrap">
          <table>
            <thead>
              <tr>
                <th style="width:15%;">رده</th>
                <th style="width:65%;">بازیکن</th>
                <th style="width:20%;"><?= $type==='goals'?'گل':'پاس گل' ?></th>
              </tr>
            </thead>
            <tbody>
                <?php foreach ($players as $i => $p):
                  $rank   = $p['Rnk'] ?? ($i+1);
                  $player = $p['Pnm'] ?? '-';
                  $team   = getTeamName($p['Tnm'] ?? '-') ?? '-';
                  if ($type === 'goals') {
                      $stat = $p['Scrs']['1'] ?? 0; // گل
                  } elseif ($type === 'assists') {
                      $stat = $p['Scrs']['3'] ?? 0; // پاس گل
                  }
                ?>
                  <tr>
                    <td><?= convertToPersianNumbers($rank) ?></td>
                    <td class="player-cell">
                      <span class="player-name"><?= htmlspecialchars($player) ?></span>
                      <span class="team-name"><?= htmlspecialchars($team) ?></span>
                    </td>
                    <td><strong><?= convertToPersianNumbers($stat) ?></strong></td>
                  </tr>
                <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
</div>

<?php $active='scorer'; include __DIR__.'/parts/bottom-nav.php'; ?>
</body>
</html>