<?php
declare(strict_types=1);

file_put_contents(__DIR__."/track_log.txt",
    date("Y-m-d H:i:s")." RAW: ".$_SERVER['REMOTE_ADDR']." ".$_SERVER['REQUEST_URI']."\n"
    .file_get_contents("php://input")."\n\n",
    FILE_APPEND
);

date_default_timezone_set('Asia/Tehran');
require_once __DIR__ . '/../BOT/LiveMrMD/admin/config.php';

// امنیت CORS و Preflight
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, X-Track-Secret');
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

// سکرت باید با مقدار داخل JS یکی باشد
$secret = $_SERVER['HTTP_X_TRACK_SECRET'] ?? '';
if ($secret !== 'MY_SUPER_SECRET_123') {
    http_response_code(401);
    echo json_encode(['ok'=>false,'error'=>'unauthorized']);
    exit;
}

require_once __DIR__ . '/config.php'; // باید $db را ست کند (PDO)

$raw = file_get_contents('php://input');
$data = json_decode($raw, true) ?: [];

$provider   = $data['provider']   ?? null;   // 'telegram' یا 'guest'
$externalId = $data['external_id'] ?? null;  // user.id تلگرام یا guest-...
$eventType  = $data['event_type'] ?? null;   // 'open_app' از مینی‌اپ

// فقط اگر از تلگرام است و آیدی عددی است ثبت کنیم
if ($eventType === 'open_app') {
    if ($provider === 'telegram' && preg_match('/^\d+$/', (string)$externalId)) {
        $uid = (string)$externalId;

        // تلگرام: آپدیت یا اینسرت در Users
        $u = $db->prepare("UPDATE `Users` SET `LastMiniAppVisit` = NOW() WHERE `UserId` = ?");
        $u->execute([$uid]);

        if ($u->rowCount() === 0) {
            $ins = $db->prepare("
                INSERT INTO `Users`(`UserId`,`Limit`,`Ban`,`HasJoin`,`Sup`,`LastMiniAppVisit`)
                VALUES (?, UNIX_TIMESTAMP(), 0, 'left', 0, NOW())
            ");
            $ins->execute([$uid]);
        }
    } else {
        // وب/مهمان: ثبت یا به‌روزرسانی در جدول MiniAppGuests
        $g = $db->prepare("
            INSERT INTO `MiniAppGuests` (`external_id`,`last_visit`)
            VALUES (?, NOW())
            ON DUPLICATE KEY UPDATE `last_visit` = VALUES(`last_visit`)
        ");
        $g->execute([(string)$externalId]);
    }

    echo json_encode(['ok'=>true]);
    exit;
}

// برای مهمان‌ها یا ورودی‌های نامعتبر، فقط ok برگردان
echo json_encode(['ok'=>true,'ignored'=>true]);
